/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.dao.impl;

import com.xebia.ad.dao.ChangePlanDao;
import com.xebia.ad.dao.impl.JpaBaseDaoImpl;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ChangePlanState;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional(propagation=Propagation.MANDATORY)
public class JpaChangePlanDaoImpl
extends JpaBaseDaoImpl<ChangePlan>
implements ChangePlanDao {
    public JpaChangePlanDaoImpl() {
        super(ChangePlan.class);
    }

    @Override
    public ChangePlan findCurrentChangePlan(String username) {
        Query query = this.entityManager.createQuery("SELECT cp FROM " + this.getEntityName() + " cp WHERE cp.state != :state1 AND cp.state != :state2 AND cp.state != :state3 AND cp.username = :username");
        query.setParameter("state1", (Object)ChangePlanState.SKIPPED);
        query.setParameter("state2", (Object)ChangePlanState.CLEARED);
        query.setParameter("state3", (Object)ChangePlanState.DONE);
        query.setParameter("username", (Object)username);
        List resultList = query.getResultList();
        if (resultList.size() != 0) {
            return (ChangePlan)resultList.get(0);
        }
        return null;
    }

    @Override
    public ChangePlan getOrCreateCurrentChangePlan(String username) {
        ChangePlan result = this.findCurrentChangePlan(username);
        if (result != null) {
            return result;
        }
        result = new ChangePlan();
        result.setUsername(username);
        result.setState(ChangePlanState.EMPTY);
        this.persist(result);
        return result;
    }

    @Override
    public List<ChangePlan> findExecutingChangePlans() {
        Query query = this.entityManager.createQuery("SELECT plan FROM " + this.getEntityName() + " plan where plan.state = 'EXECUTING'");
        return query.getResultList();
    }

    @Override
    public void updateChangePlanOlderThan(Date date) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution < :date");
        query.setParameter("date", (Object)date);
        List changePlans = query.getResultList();
        for (ChangePlan changePlan : changePlans) {
            changePlan.removeAllSteps();
        }
    }

    @Override
    public List<ChangePlan> findChangePlans(Date startDate, Date endDate) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution > :startDate and plan.endOfExecution <= :endDate order by plan.endOfExecution asc");
        query.setParameter("startDate", (Object)startDate);
        query.setParameter("endDate", (Object)endDate);
        return query.getResultList();
    }

    @Override
    public List<ChangePlan> findChangePlans(String user, Date startDate, Date endDate) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution > :startDate and plan.endOfExecution <= :endDate and plan.username = :username order by plan.endOfExecution asc");
        query.setParameter("startDate", (Object)startDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("username", (Object)user);
        return query.getResultList();
    }

    @Override
    public List<ChangePlan> findChangePlans(String user, Date startDate, Date endDate, ChangePlanState state) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution > :startDate and plan.endOfExecution <= :endDate and plan.username = :username and plan.state = :state order by plan.endOfExecution asc");
        query.setParameter("startDate", (Object)startDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("username", (Object)user);
        query.setParameter("state", (Object)state);
        return query.getResultList();
    }

    @Override
    public List<ChangePlan> findChangePlans(Date startDate, Date endDate, ChangePlanState state) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution > :startDate and plan.endOfExecution <= :endDate and plan.state = :state order by plan.endOfExecution asc");
        query.setParameter("startDate", (Object)startDate);
        query.setParameter("endDate", (Object)endDate);
        query.setParameter("state", (Object)state);
        return query.getResultList();
    }

    @Override
    public List<String> findUsernamesAssociatedWithAnyChangePlan() {
        Query query = this.entityManager.createQuery("Select distinct plan.username from " + this.getEntityName() + " plan");
        return query.getResultList();
    }

    @Override
    public List<ChangePlan> findChangePlansTillDate(Date date) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution <= :tillDate and (plan.state = :state1 or plan.state = :state2) order by plan.endOfExecution desc");
        query.setParameter("tillDate", (Object)date);
        query.setParameter("state1", (Object)ChangePlanState.DONE);
        query.setParameter("state2", (Object)ChangePlanState.SKIPPED);
        return query.getResultList();
    }
}

