/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.jetty;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.resource.Resource;

public class ClassPathResourceContentServlet
extends DefaultServlet {
    private static final String FALLBACK_SYSTEM_PROPERTY_NAME = "com.xebia.ad.jetty.ClassPathResourceContentServlet.fallbackDirectory";
    private final String packageName;
    private final boolean fallbackToDevelopmentResources;
    private final String fallbackDirectory;
    private static Logger logger = Logger.getLogger(ClassPathResourceContentServlet.class);

    public ClassPathResourceContentServlet(String packageName) {
        assert (packageName != null);
        this.packageName = packageName.replace('.', '/');
        this.fallbackDirectory = System.getProperty(FALLBACK_SYSTEM_PROPERTY_NAME);
        this.fallbackToDevelopmentResources = StringUtils.isNotEmpty((String)this.fallbackDirectory);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using " + this.packageName + " as the document root on the classpath (fallbackToDevelopmentResources=" + this.fallbackToDevelopmentResources + ")."));
        }
    }

    public Resource getResource(String pathInContext) {
        pathInContext = pathInContext.replace("-${project.version}-${deployit.edition}-edition", "");
        String resourcePath = "/" + this.packageName + pathInContext;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested resource " + resourcePath + " to load"));
        }
        URL url = ((Object)((Object)this)).getClass().getResource(resourcePath);
        try {
            Resource r = Resource.newResource((URL)url);
            if ((r == null || !r.exists()) && this.fallbackToDevelopmentResources) {
                String fallbackUrl = "file:" + this.fallbackDirectory + pathInContext;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Cannot find " + resourcePath + " in classpath, falling back to URL " + fallbackUrl));
                }
                r = Resource.newResource((String)fallbackUrl);
            }
            if (r == null || !r.exists()) {
                if (resourcePath.endsWith(".gz")) {
                    logger.debug((Object)("Cannot find " + resourcePath + " in classpath"));
                } else {
                    logger.error((Object)("Cannot find " + resourcePath + " in classpath"));
                }
            }
            return r;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }
}

