/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.reporting.transformers;

import com.xebia.ad.reporting.transformers.ReportPropertyTransformer;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReportDatePropertyTransformer
implements ReportPropertyTransformer {
    private SimpleDateFormat sdf;

    public ReportDatePropertyTransformer(String dateFormat) {
        this.sdf = new SimpleDateFormat(dateFormat);
    }

    public Serializable transformPropertyValue(Object value) {
        if (value != null && value instanceof Date) {
            Date date = (Date)value;
            return this.sdf.format(date);
        }
        return null;
    }

    public Serializable originalPropertyValue(Object value) {
        if (value != null && value instanceof String) {
            String dateStr = value.toString();
            try {
                return this.sdf.parse(dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

