/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.metadata;

import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.Language;
import com.xebia.ad.repository.metadata.OldStep;
import com.xebia.ad.repository.metadata.Step;
import com.xebia.ad.repository.metadata.StepState;
import com.xebia.ad.support.Idable;
import com.xebia.ad.support.Positionable;
import com.xebia.ad.support.SystemConstants;
import com.xebialabs.deployit.exception.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.ForeignKey;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyInstance;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.imp;
import org.python.util.PythonInterpreter;
import org.springframework.core.io.ClassPathResource;

@Entity
@Table(name="STEP")
class StepContainer
implements Idable,
Positionable {
    @Id
    @Column(name="STEP_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @Column(name="POS")
    private int position;
    @Column(name="STATE")
    @Enumerated(value=EnumType.STRING)
    private StepState state = StepState.PENDING;
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="CHANGEPLAN_ID")
    @ForeignKey(name="FK_STEP_CHANGEPLAN")
    private ChangePlan changePlan;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="LOG", length=4096)
    @Lob
    private String log;
    @Column(name="DETAILS", updatable=false, length=7000)
    @Lob
    private byte[] serializedStep;
    @Transient
    private Step step;
    @Column(name="LANGUAGE")
    @Enumerated(value=EnumType.STRING)
    private Language language = Language.JAVA;
    @Column(name="DEFININGFILE")
    private String definingFile;
    private static Logger logger = Logger.getLogger(StepContainer.class);

    StepContainer() {
    }

    StepContainer(Step step, String description) {
        this.step = step;
        this.description = description != null && description.length() > 255 ? description.substring(0, 254) : description;
    }

    public String toString() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public StepState getState() {
        return this.state;
    }

    public void setState(StepState state) {
        this.state = state;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description != null && description.length() > 255 ? description.substring(0, 254) : description;
    }

    public String getLog() {
        return this.log;
    }

    public void clearLog() {
        this.log = "";
    }

    public ChangePlan getChangePlan() {
        return this.changePlan;
    }

    void internalSetChangePlan(ChangePlan changePlan) {
        this.changePlan = changePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeStep() {
        try {
            ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectStream = new ObjectOutputStream(bytesStream);
                try {
                    String name = this.step.getClass().getName();
                    if (name.startsWith("org.python.proxies")) {
                        this.language = Language.JYTHON;
                        Step obj = this.step;
                        PyProxy proxy = (PyProxy)obj;
                        PyInstance pyinst = proxy._getPyInstance();
                        PyObject pyo = pyinst.__getattr__("definingFile");
                        this.definingFile = pyo.toString();
                    } else {
                        this.language = Language.JAVA;
                    }
                    objectStream.writeObject(this.step);
                }
                finally {
                    objectStream.close();
                }
            }
            finally {
                bytesStream.close();
            }
            this.serializedStep = bytesStream.toByteArray();
        }
        catch (IOException exc) {
            logger.error((Object)("Cannot serialize step details for " + this.step.getClass()), (Throwable)exc);
            throw new RuntimeIOException("Cannot serialize step details for " + this.step.getClass(), (Throwable)exc);
        }
    }

    Step getStep() {
        if (this.step == null) {
            this.deserializeStep();
        }
        return this.step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deserializeStep() {
        if (this.language.equals((Object)Language.JAVA)) {
            try {
                ByteArrayInputStream bytesStream = new ByteArrayInputStream(this.serializedStep);
                try {
                    ObjectInputStream objectStream = new ObjectInputStream(bytesStream);
                    try {
                        this.step = (Step)objectStream.readObject();
                        this.step.setStepContainer(this);
                    }
                    finally {
                        objectStream.close();
                    }
                }
                finally {
                    ((InputStream)bytesStream).close();
                }
                this.step.setStepContainer(this);
            }
            catch (InvalidClassException exc) {
                this.createOldStep(exc);
            }
            catch (ClassNotFoundException exc) {
                this.createOldStep(exc);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot deserialize step details for " + this, (Throwable)exc);
            }
        } else if (this.language.equals((Object)Language.JYTHON)) {
            ByteArrayInputStream fileInStream = new ByteArrayInputStream(this.serializedStep);
            Object theResult = this.deserialize(fileInStream);
            Step javaEquivalent = (Step)((PyInstance)theResult).__tojava__(Step.class);
            javaEquivalent.setStepContainer(this);
            this.step = javaEquivalent;
        } else {
            throw new RuntimeIOException("Cannot deserialize step details for " + this + " because of unknown step language: " + (Object)((Object)this.language));
        }
    }

    private Object deserialize(InputStream inStream) {
        PyModule mod = imp.addModule((String)"__main__");
        PythonInterpreter interpreter = new PythonInterpreter();
        interpreter.setLocals(mod.__dict__);
        ClassPathResource script = new ClassPathResource(this.definingFile);
        try {
            InputStream scriptIn = script.getInputStream();
            interpreter.execfile(scriptIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PyClass pySecondClass = (PyClass)interpreter.eval("JythonStepDeserializer");
        PyInstance inst2 = new PyInstance(pySecondClass);
        inst2.__init__(new PyObject[0], new String[0]);
        PyObject pyObject = inst2.invoke("deserialize", Py.java2py((Object)inStream));
        return pyObject;
    }

    private void createOldStep(Throwable exc) {
        this.step = new OldStep();
        this.setDescription(this.step.getDescription());
        this.step.setStepContainer(this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not deserialize step details for " + this + ", replacing with an instance of " + this.step.getClass().getName()), exc);
        }
    }

    public void addLogLine(String line) {
        if (this.log != null && this.log.length() > 4000) {
            return;
        }
        if (line != null) {
            line = line + SystemConstants.getLineSeparator();
            this.log = this.log != null ? this.log + line : line;
        }
    }
}

