/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.dao.ChangePlanDao;
import com.xebia.ad.deployment.PauseStep;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ChangePlanState;
import com.xebia.ad.repository.metadata.RunBookRegistry;
import com.xebia.ad.repository.metadata.Step;
import com.xebia.ad.repository.metadata.StepState;
import com.xebia.ad.service.AutomatedDeploymentListener;
import com.xebia.ad.service.ChangePlanService;
import com.xebia.ad.service.UserService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class ChangePlanServiceImpl
implements ChangePlanService {
    public static final String ERROR_MESSAGE_TOO_MANY_DEPLOYMENTS_ARE_EXECUTING = "Sorry, but I can't execute at this moment. Too many changeplans are executing at this moment. Try again later.";
    public static final String ERROR_MESSAGE_CANNOT_EXECUTE_MULTIPLE_CHANGEPLANS_TO_SAME_ENVIRONMENT = "Sorry, but I can't execute at this moment. Another changeplan is deploying to the same environment(s) as specified in this changeplan.";
    @Autowired
    private UserService userService;
    @Autowired
    private ChangePlanDao changePlanDao;
    @Autowired
    private AutomatedDeploymentListener automatedDeploymentListener;
    @Autowired
    private RunBookRegistry runBookFactoryRegistry;
    private static Logger logger = Logger.getLogger(ChangePlanServiceImpl.class);

    @Override
    public ChangePlan findCurrentChangePlan() {
        String currentUsername = this.userService.getCurrentUsername();
        return this.changePlanDao.findCurrentChangePlan(currentUsername);
    }

    @Override
    public ChangePlan getOrCreateCurrentChangePlan() {
        return this.changePlanDao.getOrCreateCurrentChangePlan(this.userService.getCurrentUsername());
    }

    @Override
    public void resolveChangePlan(ChangePlan changePlan) {
        if (!changePlan.canBeResolved()) {
            return;
        }
        changePlan.resolve(this.runBookFactoryRegistry);
        this.changePlanDao.persist(changePlan);
        this.automatedDeploymentListener.changePlanUpdated(changePlan);
    }

    @Override
    public void addPauseStepToChangePlan(ChangePlan changePlan, int position) {
        PauseStep pauseStep = new PauseStep();
        pauseStep.setDescription("Pause Step");
        pauseStep.setPosition(position);
        changePlan.addStep(pauseStep);
        this.automatedDeploymentListener.changePlanUpdated(changePlan);
    }

    @Override
    public void addPauseStepsToChangePlan(ChangePlan changePlan, Collection<Integer> positions) {
        for (int each : positions) {
            PauseStep pauseStep = new PauseStep();
            pauseStep.setDescription("Pause Step");
            pauseStep.setPosition(each);
            changePlan.addStep(pauseStep);
        }
        this.automatedDeploymentListener.changePlanUpdated(changePlan);
    }

    @Override
    public void skipStepsInChangePlan(ChangePlan changePlan, Collection<Integer> stepIds) {
        for (int each : stepIds) {
            Step s = changePlan.findStep(each);
            if (s == null) continue;
            if (s.getState() == StepState.PENDING || s.getState() == StepState.FAILED) {
                s.skip();
                continue;
            }
            if (s.getState() != StepState.SKIPPED || !changePlan.isUnSkippableStep(each)) continue;
            s.unSkip();
        }
        this.automatedDeploymentListener.changePlanUpdated(changePlan);
    }

    @Override
    public void removeStepFromChangePlan(ChangePlan changePlan, int position) {
        changePlan.removeStepByPosition(position);
        this.automatedDeploymentListener.changePlanUpdated(changePlan);
    }

    @Override
    public void checkThatChangePlanCanBeExecuted(ChangePlan changePlan) {
        if (changePlan == null) {
            throw new IllegalStateException("There is no change plan to execute");
        }
    }

    @Override
    public void updateChangePlanOlderThan(Date date) {
        this.changePlanDao.updateChangePlanOlderThan(date);
    }

    @Override
    public void skipAndCommitChangePlan(ChangePlan cp) {
        cp.skipAndCommit(this.automatedDeploymentListener);
    }

    @Override
    public void commitChangePlan(ChangePlan cp) {
        cp.setState(ChangePlanState.PENDING);
        cp.skipAndCommit(this.automatedDeploymentListener);
    }

    @Override
    public void abortChangePlan(ChangePlan cp) {
        cp.abort(this.automatedDeploymentListener);
    }

    @Override
    public void clearChangePlan(ChangePlan cp) {
        cp.clear(this.automatedDeploymentListener);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean continueExecuteAndCommitOfCurrentChangePlan(boolean firstTime, Map<String, Object> secAttributes) {
        boolean advanced;
        ChangePlan cp = this.findCurrentChangePlan();
        if (cp == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Advancing " + cp + " (firstTime=" + firstTime + ")"));
        }
        if (advanced = cp.continueExecuteAndCommit(this.automatedDeploymentListener, secAttributes, firstTime)) {
            this.automatedDeploymentListener.changePlanUpdated(cp);
        }
        return advanced;
    }

    @Override
    public void discoveryFinishedForCurrentChangePlan() {
        ChangePlan changePlan = this.changePlanDao.findCurrentChangePlan(this.userService.getCurrentUsername());
        if (changePlan.getState() == ChangePlanState.EXECUTING) {
            changePlan.setDiscovering(false);
            changePlan.setState(ChangePlanState.PENDING);
        }
        this.automatedDeploymentListener.changePlanUpdated(changePlan);
    }

    @Override
    public List<String> findUsernamesAssociatedWithAnyChangePlan() {
        return this.changePlanDao.findUsernamesAssociatedWithAnyChangePlan();
    }

    @Override
    public List<ChangePlan> getChangePlansTillDate(Date date) {
        return this.changePlanDao.findChangePlansTillDate(date);
    }

    @Override
    public List<ChangePlan> findChangePlans(Date startDate, Date endDate) {
        return this.changePlanDao.findChangePlans(startDate, endDate);
    }

    @Override
    public List<ChangePlan> findChangePlans(String user, Date startDate, Date endDate) {
        return this.changePlanDao.findChangePlans(user, startDate, endDate);
    }

    @Override
    public List<ChangePlan> findChangePlans(Date startDate, Date endDate, ChangePlanState state) {
        return this.changePlanDao.findChangePlans(startDate, endDate, state);
    }

    @Override
    public List<ChangePlan> findChangePlans(String user, Date startDate, Date endDate, ChangePlanState state) {
        return this.changePlanDao.findChangePlans(user, startDate, endDate, state);
    }

    public void setChangePlanDao(ChangePlanDao changePlanDao) {
        this.changePlanDao = changePlanDao;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

