/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.dao.ConfigurationItemHandleDao;
import com.xebia.ad.reporting.organizers.MapBasedReportDataOrganizer;
import com.xebia.ad.reporting.organizers.ObjectBasedReportDataOrganizer;
import com.xebia.ad.reporting.transformers.ReportDatePropertyTransformer;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ChangePlanState;
import com.xebia.ad.repository.metadata.ChangeType;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.service.ChangePlanService;
import com.xebia.ad.service.ReportingService;
import com.xebia.ad.service.RepositoryService;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportingServiceImpl
implements ReportingService {
    private static final String FOR_ALL_GROUP = "All";
    @Autowired(required=true)
    public ChangePlanService changePlanService;
    @Autowired(required=true)
    @Qualifier(value="defaultRepositoryService")
    public RepositoryService repositoryService;
    @Autowired
    public ConfigurationItemHandleDao configurationItemHandleDao;
    private static Logger logger = Logger.getLogger(ReportingServiceImpl.class);

    @Override
    public List<Map<Serializable, Serializable>> getDeploymentPerApplicationRecordsGridData(Date startDate, Date endDate, String applicationName) {
        List<ChangePlan> matchingChangePlans = this.changePlanService.findChangePlans(this.getStartTimeOfDay(startDate), this.getEndTimeOfDay(endDate));
        return this.getDeploymentRecordsForApplication(matchingChangePlans, applicationName);
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getDeploymentPerApplicationRecordsChartData(Date startDate, Date endDate, String applicationName) {
        List<Map<Serializable, Serializable>> applicationDeploymentRecords = this.getDeploymentPerApplicationRecordsGridData(startDate, endDate, applicationName);
        MapBasedReportDataOrganizer dataOrganizer = new MapBasedReportDataOrganizer(applicationDeploymentRecords, "date", "application", new ReportDatePropertyTransformer("MM-yyyy"));
        return dataOrganizer.getCountedGroupedData();
    }

    @Override
    public List<ChangePlan> getReportGridDataForChangePlanByUser(String user, Date startDate, Date endDate) {
        if (user.equals(FOR_ALL_GROUP)) {
            return this.changePlanService.findChangePlans(this.getStartTimeOfDay(startDate), this.getEndTimeOfDay(endDate));
        }
        return this.changePlanService.findChangePlans(user, this.getStartTimeOfDay(startDate), this.getEndTimeOfDay(endDate));
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getReportChartDataForChangePlanByUser(String user, Date startDate, Date endDate) {
        List<ChangePlan> changeplans = this.getReportGridDataForChangePlanByUser(user, startDate, endDate);
        ObjectBasedReportDataOrganizer dataOrganizer = new ObjectBasedReportDataOrganizer(changeplans, "endOfExecution", "username", new ReportDatePropertyTransformer("MM-yyyy"));
        return dataOrganizer.getCountedGroupedData();
    }

    @Override
    public List<ChangePlan> getReportGridDataForFailedChangePlanByUser(String user, Date startDate, Date endDate) {
        if (user.equals(FOR_ALL_GROUP)) {
            return this.changePlanService.findChangePlans(this.getStartTimeOfDay(startDate), this.getEndTimeOfDay(endDate), ChangePlanState.FAILED);
        }
        return this.changePlanService.findChangePlans(user, this.getStartTimeOfDay(startDate), this.getEndTimeOfDay(endDate), ChangePlanState.FAILED);
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getReportChartDataForFailedChangePlanByUser(String user, Date startDate, Date endDate) {
        List<ChangePlan> changeplans = this.getReportGridDataForFailedChangePlanByUser(user, startDate, endDate);
        ObjectBasedReportDataOrganizer dataOrganizer = new ObjectBasedReportDataOrganizer(changeplans, "endOfExecution", "username", new ReportDatePropertyTransformer("MM-yyyy"));
        return dataOrganizer.getCountedGroupedData();
    }

    @Override
    public List<Map<Serializable, Serializable>> getGridDataForCiOfTypePerApplication(String ciType, String application) {
        ArrayList<Map<Serializable, Serializable>> records = new ArrayList<Map<Serializable, Serializable>>();
        List<ConfigurationItemHandle> allHandles = this.configurationItemHandleDao.findHandlesWithActualRevisionOfType(DeploymentPackage.class.getName());
        for (ConfigurationItemHandle eachHandle : allHandles) {
            DeploymentPackage dp = (DeploymentPackage)this.repositoryService.getConfigurationItemDetailsObject(eachHandle.getActualRevision().getId());
            if (dp.getApplication() == null || !dp.getApplication().getLabel().equals(application)) continue;
            try {
                Class<?> ciTypeClass = Class.forName(ciType);
                Collection members = dp.getMembersOfType(ciTypeClass);
                for (Object member : members) {
                    Object valueOfMethodInvocation = this.getValueOfMethodInvocation(member, "label");
                    if (valueOfMethodInvocation == null) continue;
                    HashMap<String, String> record = new HashMap<String, String>();
                    record.put("deploymentPackage", eachHandle.getLabel());
                    record.put("version", dp.getVersion());
                    record.put("ciLabel", valueOfMethodInvocation.toString());
                    records.add(record);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("No class found for CI type:" + ciType));
            }
        }
        return records;
    }

    @Override
    public List<Map<Serializable, Serializable>> getReportGridDataForDeploymentsOnDomain(String wlsDomain, Date deploymentDate) {
        List<ChangePlan> matchingChangePlans = this.changePlanService.getChangePlansTillDate(this.getEndTimeOfDay(deploymentDate));
        return this.getDeploymentRecordsForDomain(matchingChangePlans, wlsDomain);
    }

    @Override
    public List<Map<Serializable, Serializable>> getReportGridDataForDeploymentsOnEnvironment(String environment, Date deploymentDate) {
        List<ChangePlan> matchingChangePlans = this.changePlanService.getChangePlansTillDate(this.getEndTimeOfDay(deploymentDate));
        return this.getDeploymentRecordsForEnvironment(matchingChangePlans, environment);
    }

    private List<Map<Serializable, Serializable>> getDeploymentRecordsForApplication(List<ChangePlan> matchingChangePlans, String applicationName) {
        ArrayList<Map<Serializable, Serializable>> deploymentRecords = new ArrayList<Map<Serializable, Serializable>>();
        for (ChangePlan cp : matchingChangePlans) {
            for (Change change : cp.getChanges()) {
                ConfigurationItemRevision revision;
                if (!Deployment.class.getName().equals(change.getConfigurationItemType())) continue;
                revision = change.getType().equals((Object)ChangeType.DELETION) ? (revision = change.getOldRevision()) : change.getNewRevision();
                Deployment deployment = (Deployment)this.repositoryService.getConfigurationItemDetailsObject(revision.getId());
                String applicationLabel = deployment.getSource().getApplication().getLabel();
                if (!applicationName.equals(FOR_ALL_GROUP) && !applicationLabel.equals(applicationName)) continue;
                String version = deployment.getSource().getVersion();
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("date", cp.getEndOfExecution());
                record.put("application", applicationLabel);
                record.put("version", version);
                record.put("user", cp.getUsername());
                record.put("status", cp.getState().toString());
                record.put("type", change.getType().toString());
                deploymentRecords.add(record);
            }
        }
        return deploymentRecords;
    }

    private List<Map<Serializable, Serializable>> getDeploymentRecordsForDomain(List<ChangePlan> matchingChangePlans, String domainName) {
        ArrayList<Map<Serializable, Serializable>> matchingDeployments = new ArrayList<Map<Serializable, Serializable>>();
        ArrayList<String> applicationList = new ArrayList<String>();
        for (ChangePlan cp : matchingChangePlans) {
            for (Change change : cp.getChanges()) {
                ConfigurationItemRevision revision;
                Deployment deployment;
                if (!Deployment.class.getName().equals(change.getConfigurationItemType()) || !this.doesDomainExistInEnvironement(domainName, (deployment = (Deployment)this.repositoryService.getConfigurationItemDetailsObject((revision = change.getType().equals((Object)ChangeType.DELETION) ? (revision = change.getOldRevision()) : change.getNewRevision()).getId())).getTarget())) continue;
                Application application = deployment.getSource().getApplication();
                String applicationLabel = application.getLabel();
                String version = deployment.getSource().getVersion();
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("date", cp.getEndOfExecution());
                record.put("application", applicationLabel);
                record.put("version", version);
                record.put("user", cp.getUsername());
                if (applicationList.contains(applicationLabel)) continue;
                applicationList.add(applicationLabel);
                if (change.getType().equals((Object)ChangeType.DELETION)) continue;
                matchingDeployments.add(record);
            }
        }
        return matchingDeployments;
    }

    private List<Map<Serializable, Serializable>> getDeploymentRecordsForEnvironment(List<ChangePlan> matchingChangePlans, String environmentName) {
        ArrayList<Map<Serializable, Serializable>> matchingDeployments = new ArrayList<Map<Serializable, Serializable>>();
        ArrayList<String> applicationList = new ArrayList<String>();
        for (ChangePlan cp : matchingChangePlans) {
            for (Change change : cp.getChanges()) {
                ConfigurationItemRevision revision;
                Deployment deployment;
                Environment target;
                if (!Deployment.class.getName().equals(change.getConfigurationItemType()) || !(target = (deployment = (Deployment)this.repositoryService.getConfigurationItemDetailsObject((revision = change.getType().equals((Object)ChangeType.DELETION) ? (revision = change.getOldRevision()) : change.getNewRevision()).getId())).getTarget()).getLabel().equals(environmentName)) continue;
                Application application = deployment.getSource().getApplication();
                String applicationLabel = application.getLabel();
                String version = deployment.getSource().getVersion();
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("date", cp.getEndOfExecution());
                record.put("application", applicationLabel);
                record.put("version", version);
                record.put("user", cp.getUsername());
                if (applicationList.contains(applicationLabel)) continue;
                applicationList.add(applicationLabel);
                if (change.getType().equals((Object)ChangeType.DELETION)) continue;
                matchingDeployments.add(record);
            }
        }
        return matchingDeployments;
    }

    private boolean doesDomainExistInEnvironement(String domainLabel, Environment env) {
        try {
            Object thisDomainLabel;
            Object thisDomain;
            Class<?> wlsServerClass = Class.forName("com.xebialabs.deployit.plugin.wls.ci.WlsServer");
            Class<?> wlsClusterClass = Class.forName("com.xebialabs.deployit.plugin.wls.ci.WlsCluster");
            Set wlsServers = env.getMembersOfType(wlsServerClass);
            Set wlsClusters = env.getMembersOfType(wlsClusterClass);
            for (Serializable eachServer : wlsServers) {
                thisDomain = this.getValueOfMethodInvocation(eachServer, "domain");
                thisDomainLabel = this.getValueOfMethodInvocation(thisDomain, "label");
                if (!thisDomainLabel.equals(domainLabel)) continue;
                return true;
            }
            for (Serializable eachCluster : wlsClusters) {
                thisDomain = this.getValueOfMethodInvocation(eachCluster, "domain");
                thisDomainLabel = this.getValueOfMethodInvocation(thisDomain, "label");
                if (!thisDomainLabel.equals(domainLabel)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Class was not found at run-time for WlsServer or WlsCluster");
        }
        return false;
    }

    private Object getValueOfMethodInvocation(Object obj, String property) {
        Object value = null;
        try {
            Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)obj, (String)property));
            value = getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            logger.warn((Object)("No getter found for property:" + property + " on object of type:" + obj.getClass()));
        }
        return value;
    }

    private Date getStartTimeOfDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
        String dateWithoutTimeStr = sdf.format(date);
        Date startDate = null;
        try {
            startDate = sdf.parse(dateWithoutTimeStr);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return startDate;
    }

    private Date getEndTimeOfDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
        String dateWithoutTimeStr = sdf.format(date);
        Date dateWithoutTime = null;
        try {
            dateWithoutTime = sdf.parse(dateWithoutTimeStr);
        }
        catch (ParseException e) {
            // empty catch block
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateWithoutTime);
        calendar.add(5, 1);
        calendar.add(13, -1);
        return calendar.getTime();
    }
}

