/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.setup;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.ReleaseInfo;
import com.xebia.ad.setup.SetupContext;
import com.xebia.ad.setup.SetupDatabaseType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Setup {
    private static final String DEFAULT_HTTP_SERVER = "localhost";
    private static final int DEFAULT_HTTP_PORT = 4516;
    private static final int DEFAULT_HTTPS_PORT = 4517;
    private static final int DEFAULT_MAX_THREADS = 24;
    private static final int DEFAULT_MIN_THREADS = 3;
    private static final String DEFAULT_ADMIN_GROUP_NAME = "DEPLOYIT_ADMINS";
    private static final String DEFAULT_APPLICATION_TO_DEPLOY_PATH = "importablePackages";
    private static final String DEFAULT_APPLICATIONREPOSITORY = "data";
    private static final String EXITSETUP_KEYWORD = "exitsetup";

    public static void main(String[] args) {
        Setup setup = new Setup();
        setup.run();
    }

    private void run() {
        System.out.println("\nWelcome to the Deployit setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the Deployit server configuration you can run deployit.cmd -setup on Windows or deployit.sh -setup on Unix.");
        SetupContext context = new SetupContext();
        boolean editingExistingConfiguration = false;
        if (context.exists()) {
            if (this.askDoYouWantToEditTheExistingConfiguration(context)) {
                context.load();
                editingExistingConfiguration = true;
            }
        } else if (!ReleaseInfo.getReleaseInfo().isEnterpriseEdition()) {
            if (!this.showPersonalEditionLicenseAndAskToAgree()) {
                System.out.println("You have not agreed to the Deployit Personal Edition License, exiting...");
                System.exit(1);
            } else {
                System.out.println("Thank you for accepting the license agreement.");
            }
        }
        if (this.askDoYouWantToUseTheSimpleSetup()) {
            if (!editingExistingConfiguration) {
                this.useDefaultValues(context);
            } else {
                this.upgradeConfigurationWithDefaultValues(context);
            }
            this.askToInitializeDatabase(context);
            if (context.doesApplicationRepositoryExist()) {
                this.askToRemoveApplicationRepositoryContents(context);
            } else {
                this.askToCreateApplicationRepository(context);
            }
        } else {
            ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
            if (releaseInfo.isEnterpriseEdition()) {
                if (this.askToEnableSecurity(context)) {
                    this.askForLdapHost(context);
                    this.askForLdapPort(context);
                    this.askForLdapBaseDn(context);
                    this.askForLdapConnectDn(context);
                    this.askForLdapConnectPassword(context);
                    this.askForLdapGroupSearchFilter(context);
                    this.askForAdministratorGroup(context);
                }
                if (this.askToEnableSsl(context)) {
                    if (this.askToGenerateKeys(context)) {
                        this.setDefaultKeyStoreSettings(context);
                    } else {
                        this.askKeyStoreSettings(context);
                    }
                }
            }
            this.askHttpServerNameForJetty(context);
            this.askHttpPortForJetty(context);
            this.askMinumAmountOfThreads(context);
            this.askMaximumAmountOfThreads(context);
            this.askWhatTypeOfDatabase(context);
            this.askConnectionInfoForDatabase(context);
            this.askUsernameForDatabase(context);
            this.askPasswordForDatabase(context);
            if (!this.askToInitializeDatabase(context) && this.askToGenerateSchema(context)) {
                this.askForPathForGeneratedSchemaFile(context);
            }
            this.askApplicationToDeployPath(context);
            this.askApplicationRepositoryPath(context);
            if (!context.doesApplicationRepositoryExist()) {
                this.askToCreateApplicationRepository(context);
            } else {
                this.askToRemoveApplicationRepositoryContents(context);
            }
        }
        if (this.reviewAndConfirm(context)) {
            System.out.println("Saving to " + context.getLocation());
            context.save();
            System.out.println("Configuration saved.");
            if (context.isGenerateKeyStore()) {
                this.generateKeyStore(context);
            }
            if (context.isInitializeDatabase()) {
                if (context.isDatabaseDriverAvailable()) {
                    this.initializeDatabase(context);
                } else {
                    System.out.println("Skipping datbase initialization.");
                }
                if (context.shouldApplicationRepositoryContentsBeRemoved()) {
                    this.removeApplicationRepositoryContents(context);
                }
            }
            if (context.isGenerateSchema()) {
                this.copyDatabaseSchema(context);
            }
            if (context.isCreateApplicationRepository()) {
                this.createApplicationRepositoryDirectory(context);
            }
            System.out.println("You can now start your Deployit server by executing the command deployit.cmd on Windows or deployit.sh on Unix.");
            System.out.println("Note: If your Deployit server is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private boolean showPersonalEditionLicenseAndAskToAgree() {
        this.printEmptyLine();
        System.out.println("To start using Deployit Personal Edition you must first read and agree to the license agreement.");
        System.out.println("Press <enter> to continue.");
        this.read();
        ClassPathResource licenseResource = new ClassPathResource("license.txt");
        try {
            int c;
            InputStream licenseInputStream = licenseResource.getInputStream();
            int lines = 0;
            while ((c = licenseInputStream.read()) != -1) {
                if (c == 10) {
                    ++lines;
                }
                System.out.print((char)c);
                if (lines != 25) continue;
                System.out.println("\n---press enter for more---");
                this.read();
                lines = 0;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to read from resource input " + licenseResource + ", message:" + e.getMessage());
            System.exit(1);
        }
        String agreeAnswer = null;
        while (!"yes".equalsIgnoreCase(agreeAnswer) && !"no".equalsIgnoreCase(agreeAnswer)) {
            System.out.println("Please answer with \"yes\" to agree with the license and continue or \"no\" to disagree and exit Deployit.");
            agreeAnswer = this.getStringResponse("");
        }
        return "yes".equalsIgnoreCase(agreeAnswer);
    }

    private void upgradeConfigurationWithDefaultValues(SetupContext context) {
        if (context.getMinThreads() == 0) {
            context.setMinThreads(3);
        }
        if (context.getMaxThreads() == 0) {
            context.setMaxThreads(24);
        }
    }

    private void askMinumAmountOfThreads(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 3 for single user usage)");
        int minThreads = 3;
        int suppliedMinThreads = context.getMinThreads() == 0 ? minThreads : context.getMinThreads();
        context.setMinThreads(this.getValidIntegerResponse(suppliedMinThreads));
    }

    private void askMaximumAmountOfThreads(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 24 for 8 concurrent users)");
        int maxThreads = 24;
        int suppliedMaxThreads = context.getMaxThreads() == 0 ? maxThreads : context.getMaxThreads();
        context.setMaxThreads(this.getValidIntegerResponse(suppliedMaxThreads));
    }

    private void askToRemoveApplicationRepositoryContents(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like to remove the application repository contents at " + context.getApplicationRepositoryPath());
        System.out.println("Options are yes or no.");
        context.setRemoveApplicationRepositoryContents(this.getBooleanResponse(false));
    }

    private void useDefaultValues(SetupContext context) {
        context.setDatabaseType(SetupDatabaseType.HSQLDB);
        context.setDatabaseDriverClass(SetupDatabaseType.getDefaultDatabaseDriverClass(context.getDatabaseType()));
        context.setHibernateDialect(SetupDatabaseType.getHibernateDialect(context.getDatabaseType()));
        context.setDatabaseURL(SetupDatabaseType.getDefaultConnectionURL(context.getDatabaseType()));
        context.setDatabaseUsername(SetupDatabaseType.getDefaultUsername(context.getDatabaseType()));
        context.setDatabasePassword("");
        context.setApplicationRepositoryPath(DEFAULT_APPLICATIONREPOSITORY);
        context.setHttpPort(4516);
        context.setHttpServerName(DEFAULT_HTTP_SERVER);
        context.setApplicationToDeployPath(DEFAULT_APPLICATION_TO_DEPLOY_PATH);
        context.setMinThreads(3);
        context.setMaxThreads(24);
    }

    private boolean askDoYouWantToUseTheSimpleSetup() {
        this.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return this.getBooleanResponse(true);
    }

    private boolean askToEnableSecurity(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like to enable security?");
        System.out.println("Options are yes or no.");
        boolean suppliedSecured = context.isNewConfiguration() ? false : context.isSecured();
        context.setSecured(this.getBooleanResponse(suppliedSecured));
        return context.isSecured();
    }

    private boolean askToEnableSsl(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedSsl = context.isNewConfiguration() ? context.isSecured() : context.isSsl();
        context.setSsl(this.getBooleanResponse(suppliedSsl));
        return context.isSsl();
    }

    private void askForLdapHost(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter host name for ldap server");
        context.setLdapHost(this.getStringResponse(context.getLdapHost() != null ? context.getLdapHost() : "ldap.mycompany.com"));
    }

    private void askForLdapPort(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter port number for ldap server");
        int defaultLdapPort = 389;
        int suppliedPort = context.getLdapPort() == 0 ? defaultLdapPort : context.getLdapPort();
        context.setLdapPort(this.getValidIntegerResponse(suppliedPort));
    }

    private void askForLdapBaseDn(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter base DN for ldap server");
        context.setLdapBaseDn(this.getStringResponse(context.getLdapBaseDn() != null ? context.getLdapBaseDn() : "o=xebialabs,c=nl"));
    }

    private void askForLdapConnectDn(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter connection DN for ldap server");
        context.setLdapConnectDn(this.getStringResponse(context.getLdapConnectDn() != null ? context.getLdapConnectDn() : "cn=Manager,o=xebialabs,c=nl"));
    }

    private void askForLdapConnectPassword(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter connection password for ldap server?");
        context.setLdapConnectPassword(this.getStringResponse(context.getLdapConnectPassword() != null ? context.getLdapConnectPassword() : "secret"));
    }

    private void askForLdapGroupSearchFilter(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the ldap group search filter?");
        context.setLdapGroupSearchFilter(this.getStringResponse(context.getLdapGroupSearchFilter() != null ? context.getLdapGroupSearchFilter() : "uniqueMember={0}"));
    }

    private void askForAdministratorGroup(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the Administrator group name?");
        context.setAdministratorGroupName(this.getStringResponse(context.getAdministratorGroupName() != null ? context.getAdministratorGroupName() : DEFAULT_ADMIN_GROUP_NAME));
    }

    private boolean askToGenerateKeys(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like Deployit to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean suppliedGenerateKeys = context.isNewConfiguration() ? true : context.isGenerateKeyStore();
        context.setGenerateKeyStore(this.getBooleanResponse(suppliedGenerateKeys));
        return context.isGenerateKeyStore();
    }

    private void setDefaultKeyStoreSettings(SetupContext context) {
        context.setKeyStorePath("keystore.jks");
        context.setKeyStorePassword("storesecret");
        context.setKeyStoreKeyPassword("keysecret");
    }

    private void askKeyStoreSettings(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What is the path to the keystore?");
        String suppliedKeyStorePath = context.isNewConfiguration() ? "" : context.getKeyStorePath();
        context.setKeyStorePath(this.getStringResponse(suppliedKeyStorePath));
        this.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        String suppliedKeyStorePassword = context.isNewConfiguration() ? "" : context.getKeyStorePassword();
        context.setKeyStorePassword(this.getStringResponse(suppliedKeyStorePassword));
        this.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        String suppliedKeyStoreKeyPassword = context.isNewConfiguration() ? "" : context.getKeyStoreKeyPassword();
        context.setKeyStoreKeyPassword(this.getStringResponse(suppliedKeyStoreKeyPassword));
    }

    private void askHttpServerNameForJetty(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What http server name?");
        context.setHttpServerName(this.getStringResponse(context.getHttpServerName() != null ? context.getHttpServerName() : DEFAULT_HTTP_SERVER));
    }

    private void askHttpPortForJetty(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int defaultPort = context.isSecured() ? 4517 : 4516;
        int suppliedPort = context.getHttpPort() == 0 ? defaultPort : context.getHttpPort();
        context.setHttpPort(this.getValidIntegerResponse(suppliedPort));
    }

    private void createApplicationRepositoryDirectory(SetupContext context) {
        File appRepoDir = new File(context.getApplicationRepositoryPath());
        if (appRepoDir.mkdir()) {
            System.out.println("Application repository " + context.getApplicationRepositoryPath() + " created.");
        } else {
            System.err.println("WARNING: Could not create directory " + context.getApplicationRepositoryPath());
        }
    }

    private void askToCreateApplicationRepository(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Application repository " + context.getApplicationRepositoryPath() + " does not exist. Do you want Deployit to create it for you?");
        System.out.println("Options are yes or no.");
        context.setCreateApplicationRepository(this.getBooleanResponse(true));
    }

    private void removeApplicationRepositoryContents(SetupContext context) {
        String repositoryPath = context.getApplicationRepositoryPath();
        System.out.println("Removing all contents of application repository at " + repositoryPath);
        this.removeDirectoryContent(repositoryPath);
    }

    private void removeDirectoryContent(String repositoryPath) {
        File file = new File(repositoryPath);
        if (file.exists()) {
            File[] allFiles;
            for (File fileInPath : allFiles = file.listFiles()) {
                this.recursivelyDelete(fileInPath);
                System.out.println("Deleted " + fileInPath.getName());
            }
        }
    }

    private void recursivelyDelete(File f) {
        if (f.exists() && f.isFile()) {
            f.delete();
        } else if (f.exists() && f.isDirectory()) {
            File[] allFiles;
            for (File fileInPath : allFiles = f.listFiles()) {
                this.recursivelyDelete(fileInPath);
            }
            f.delete();
        }
    }

    private void askApplicationRepositoryPath(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to store imported applications?");
        String suppliedApplicationRepositoryPath = context.getApplicationRepositoryPath() == null ? DEFAULT_APPLICATIONREPOSITORY : context.getApplicationRepositoryPath();
        context.setApplicationRepositoryPath(this.getValidNotEmptyStringResponse(suppliedApplicationRepositoryPath));
    }

    private void askApplicationToDeployPath(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to import applications from?");
        String suppliedApplicationImportPath = context.getApplicationToDeployPath() == null ? DEFAULT_APPLICATION_TO_DEPLOY_PATH : context.getApplicationToDeployPath();
        context.setApplicationToDeployPath(this.getValidNotEmptyStringResponse(suppliedApplicationImportPath));
    }

    private boolean askDoYouWantToEditTheExistingConfiguration(SetupContext context) {
        this.printEmptyLine();
        System.out.println("An existing configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean useOldConfig = this.getBooleanResponse(true);
        if (useOldConfig) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return useOldConfig;
    }

    private boolean askToGenerateSchema(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like Deployit to generate a schema for " + (Object)((Object)context.getDatabaseType()) + "?");
        System.out.println("Options are yes or no.");
        if (context.isNewConfiguration()) {
            context.setGenerateSchema(this.getBooleanResponse(true));
        } else {
            context.setGenerateSchema(this.getBooleanResponse(false));
        }
        if (context.isInitializeDatabase()) {
            System.out.println("Deployit will generate a schema.");
        } else {
            System.out.println("Deployit will NOT generate a schema.");
        }
        return context.isGenerateSchema();
    }

    private void askForPathForGeneratedSchemaFile(SetupContext context) {
        this.printEmptyLine();
        System.out.println("In which directory would you like Deployit to place the schema for " + (Object)((Object)context.getDatabaseType()) + "?");
        System.out.println("Examples are; on Unix /home/jdoe/deployitschema/, on Windows C:\\deployitschema\\");
        context.setGeneratedSchemaPath(this.getValidNotEmptyStringResponse(null));
        System.out.println("Deployit will store the schema's in the directory " + context.getGeneratedSchemaPath());
    }

    private boolean askToInitializeDatabase(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Do you want Deployit to initialize the database?");
        System.out.println("Options are yes or no.");
        if (context.isNewConfiguration() && context.getDatabaseType().equals((Object)SetupDatabaseType.HSQLDB)) {
            context.setInitializeDatabase(this.getBooleanResponse(true));
        } else {
            context.setInitializeDatabase(this.getBooleanResponse(false));
        }
        if (context.isInitializeDatabase()) {
            System.out.println("Deployit will initialize the database.");
        } else {
            System.out.println("Deployit will NOT initialize the database.");
        }
        return context.isInitializeDatabase();
    }

    private void askPasswordForDatabase(DeployItConfiguration context) {
        this.printEmptyLine();
        System.out.println("Supply the password for the " + (Object)((Object)context.getDatabaseType()) + " database? (can be empty)");
        context.setDatabasePassword(this.getStringResponse(context.getDatabasePassword() == null ? "" : context.getDatabasePassword()));
        if (context.getDatabasePassword().equals("")) {
            System.out.println("Password is not set.");
        } else {
            System.out.println("Password is set.");
        }
    }

    private void askUsernameForDatabase(DeployItConfiguration context) {
        this.printEmptyLine();
        System.out.println("Supply the username for the " + (Object)((Object)context.getDatabaseType()) + " database? (can be empty)");
        context.setDatabaseUsername(this.getStringResponse(context.getDatabaseUsername() == null ? SetupDatabaseType.getDefaultUsername(context.getDatabaseType()) : context.getDatabaseUsername()));
        if (context.getDatabaseUsername().equals("")) {
            System.out.println("Username is not set.");
        } else {
            System.out.println("Username is set to " + context.getDatabaseUsername());
        }
    }

    private void askConnectionInfoForDatabase(DeployItConfiguration context) {
        this.printEmptyLine();
        System.out.println("Supply the connection URL for the " + (Object)((Object)context.getDatabaseType()) + " database?");
        System.out.println("Example; " + SetupDatabaseType.getExampleConnectionURL(context.getDatabaseType()));
        context.setDatabaseURL(this.getValidNotEmptyStringResponse(context.getDatabaseURL() == null ? SetupDatabaseType.getDefaultConnectionURL(context.getDatabaseType()) : context.getDatabaseURL()));
        System.out.println("Chosen connection URL is set to " + context.getDatabaseURL());
    }

    private void askWhatTypeOfDatabase(DeployItConfiguration context) {
        this.printEmptyLine();
        System.out.println("What type of database would you like to use?");
        System.out.println("Options are oracle, mysql, hsqldb, and db2.");
        context.setDatabaseType(this.getValidEnumResponse(context.getDatabaseType() == null ? "hsqldb" : context.getDatabaseType().toString(), SetupDatabaseType.class));
        context.setDatabaseDriverClass(SetupDatabaseType.getDefaultDatabaseDriverClass(context.getDatabaseType()));
        context.setHibernateDialect(SetupDatabaseType.getHibernateDialect(context.getDatabaseType()));
        System.out.println("Chosen Database is set to " + (Object)((Object)context.getDatabaseType()));
    }

    private boolean reviewAndConfirm(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Do you agree with the following settings for Deployit and would you like to save them?");
        System.out.println("Changes will be saved in deployit.conf");
        System.out.println("\tSecurity will be " + (context.isSecured() ? "enabled" : "disabled"));
        if (context.isSecured()) {
            System.out.println("\tLDAP server Host is " + context.getLdapHost());
            System.out.println("\tLDAP BaseDN is " + context.getLdapBaseDn());
            System.out.println("\tLDAP Server Port is " + context.getLdapPort());
            System.out.println("\tLDAP ConnectDN is " + context.getLdapConnectDn());
            System.out.println("\tLDAP Server password is " + context.getLdapConnectPassword());
        }
        System.out.println("\tSSL will be " + (context.isSsl() ? "enabled" : "disabled"));
        if (context.isSsl()) {
            if (context.isGenerateKeyStore()) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + context.getKeyStorePath());
                System.out.println("\tKeystore password is " + context.getKeyStorePassword());
                System.out.println("\tKeystore key password is " + context.getKeyStoreKeyPassword());
            }
        }
        System.out.println("\tHTTP server name is " + context.getHttpServerName());
        System.out.println("\tHTTP port is " + context.getHttpPort());
        System.out.println("\tHTTP server will use a minimum of " + context.getMinThreads() + " and a maximum of " + context.getMaxThreads() + " threads");
        System.out.println("\tDatabase type is " + (Object)((Object)context.getDatabaseType()));
        System.out.println("\tDatabase URL is " + context.getDatabaseURL());
        if (StringUtils.isNotBlank((String)context.getDatabaseUsername())) {
            System.out.println("\tDatabase username is " + context.getDatabaseUsername());
        }
        if (StringUtils.isNotBlank((String)context.getDatabasePassword())) {
            System.out.println("\tDatabase password is " + context.getDatabasePassword());
        }
        System.out.println("\tDatabase driver class (value is derived) is " + context.getDatabaseDriverClass());
        if (!context.isDatabaseDriverAvailable()) {
            System.err.println("\t\tWARNING: Database Driver could not be loaded!");
            System.err.println("\t\tYou need to put the database driver on the classpath and run Deployit WITHOUT the -jar option.");
            System.err.println("\t\tExample; java -classpath <database_driver>.jar:deployit.jar com.xebia.ad.DeployIt -setup");
        }
        if (context.isInitializeDatabase()) {
            if (context.isDatabaseDriverAvailable()) {
                System.out.println("\tDatabase will be initialized");
            } else {
                System.err.println("\tCannot initialize the database. Restart setup after supplying the database driver on the classpath.");
            }
        }
        if (context.isGenerateSchema()) {
            System.out.println("\tDatabase schema will be stored in the directory " + context.getGeneratedSchemaPath());
        }
        System.out.println("\tApplication repository is " + context.getApplicationRepositoryPath());
        if (context.isCreateApplicationRepository()) {
            System.out.println("\tApplication repository " + context.getApplicationRepositoryPath() + " will be created.");
        }
        if (context.shouldApplicationRepositoryContentsBeRemoved()) {
            System.out.println("\tApplication repository contents will be removed.");
        }
        System.out.println("\tApplication import location is " + context.getApplicationToDeployPath());
        return this.getBooleanResponse(true);
    }

    private void generateKeyStore(SetupContext context) {
        String keyAlgorithm = "RSA";
        String keyStoreKeyAlias = "jetty";
        String dname = "CN=localhost,O=Deployit,C=NL";
        try {
            int exitValue;
            File keyStoreFile = new File(context.getKeyStorePath());
            if (keyStoreFile.exists()) {
                System.out.println("Existing keystore " + context.getKeyStorePath() + " deleted.");
                keyStoreFile.delete();
            }
            System.out.println("Generating keystore...");
            String[] keytoolArgs = new String[]{"keytool", "-genkey", "-keyalg", keyAlgorithm, "-keystore", context.getKeyStorePath(), "-storepass", context.getKeyStorePassword(), "-alias", keyStoreKeyAlias, "-keypass", context.getKeyStoreKeyPassword(), "-validity", "366", "-dname", dname};
            Process p = Runtime.getRuntime().exec(keytoolArgs);
            Thread outputThread = new Thread(new InputStreamToOutputStream(p.getInputStream(), System.out));
            outputThread.start();
            Thread errorThread = new Thread(new InputStreamToOutputStream(p.getErrorStream(), System.err));
            errorThread.start();
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException exc) {
                throw new IOException(exc.toString());
            }
            if (exitValue != 0) {
                throw new IOException("keytool exited with status code " + exitValue);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not generate keystore keystore.jks: " + exc.toString());
        }
    }

    private void initializeDatabase(SetupContext context) {
        System.out.println("Initializing database...");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"ad-repository", context.getCreationalJPAProperties());
        emf.close();
        System.out.println("Database initialized.");
    }

    private void copyDatabaseSchema(SetupContext context) {
        String schemaname = SetupDatabaseType.getDatabaseJPAConfiguration(context.getDatabaseType());
        ClassPathResource createSchemaResource = new ClassPathResource("schemas/ad_" + schemaname + "_schema_create.sql");
        ClassPathResource dropSchemaResource = new ClassPathResource("schemas/ad_" + schemaname + "_schema_drop.sql");
        this.copyDatabaseSchemaFile(context, (Resource)createSchemaResource);
        this.copyDatabaseSchemaFile(context, (Resource)dropSchemaResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDatabaseSchemaFile(SetupContext context, Resource schema) {
        File schemaFile = new File(context.getGeneratedSchemaPath(), schema.getFilename());
        try {
            InputStream schemaIn = schema.getInputStream();
            try {
                FileOutputStream schemaOut = new FileOutputStream(schemaFile);
                try {
                    IOUtils.copy((InputStream)schemaIn, (OutputStream)schemaOut);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    IOUtils.closeQuietly((OutputStream)schemaOut);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)schemaOut);
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                IOUtils.closeQuietly((InputStream)schemaIn);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)schemaIn);
            System.out.println("Generated schema file " + schemaFile);
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not write schema file to " + schemaFile + ": " + exc.toString());
        }
    }

    private void printEmptyLine() {
        System.out.println("");
    }

    private String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String value = stdin.readLine().trim();
            if (EXITSETUP_KEYWORD.equals(value)) {
                System.out.println("Exiting setup.");
                System.exit(1);
            }
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SetupDatabaseType getValidEnumResponse(String defaultValue, Class<?> clazz) {
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("")) {
                value = defaultValue;
            }
            try {
                return SetupDatabaseType.valueOf(value.trim().toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Illegal value specified, please try again.");
                continue;
            }
            break;
        }
    }

    private boolean getBooleanResponse(boolean defaultValue) {
        String prompt = this.determinePrompt(defaultValue ? "yes" : "no");
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("")) {
                return defaultValue;
            }
            if (value.equalsIgnoreCase("yes")) {
                return true;
            }
            if (value.equalsIgnoreCase("no")) {
                return false;
            }
            System.out.println("Illegal value specified, type yes or no.");
        }
    }

    private String getValidNotEmptyStringResponse(String defaultValue) {
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("") && defaultValue != null) {
                value = defaultValue;
            }
            if (!value.equals("")) {
                return value;
            }
            System.out.println("Value cannot be empty.");
        }
    }

    private String getStringResponse(String defaultValue) {
        String prompt = this.determinePrompt(defaultValue);
        System.out.print(prompt);
        String value = this.read();
        if (value.equals("")) {
            value = defaultValue;
        }
        return value;
    }

    private int getValidIntegerResponse(int defaultValueAsAnInt) {
        String defaultValue = Integer.toString(defaultValueAsAnInt);
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("")) {
                value = defaultValue;
            }
            try {
                int returnedValue = Integer.parseInt(value);
                if (returnedValue > 0) {
                    return returnedValue;
                }
                System.out.println("Illegal value specified. Number must be larger then 0.");
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Illegal value specified. Must be a number.");
                continue;
            }
            break;
        }
    }

    private String determinePrompt(String defaultValue) {
        String prompt = defaultValue != null ? "[" + defaultValue + "]: " : ": ";
        return prompt;
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public InputStreamToOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            try {
                IOUtils.copy((InputStream)this.in, (OutputStream)this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

