/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.application.importer;

import com.google.common.collect.Maps;
import com.xebia.ad.application.importer.DeploymentPackageImportErrors;
import com.xebia.ad.application.importer.DeploymentPackageImportService;
import com.xebia.ad.application.importer.DeploymentPackageLocation;
import com.xebia.ad.conversion.ConversionException;
import com.xebia.ad.conversion.PropertyListConverter;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.support.LabelGenerator;
import com.xebia.ad.support.LaxSSLProtocolSocketFactory;
import com.xebia.ad.support.Triple;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestBasedDeploymentPackageImportService
implements DeploymentPackageImportService {
    public static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    public static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.1";
    public static final String APPLICATION_ATTRIBUTE_NAME = "CI-Application";
    public static final String VERSION_ATTRIBUTE_NAME = "CI-Version";
    public static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    public static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    public static final String NAMESPACE_SEPARATOR = "/";
    private RepositoryService repositoryService;
    private ConfigurationItemTypeDescriptorRepository typeRepository;
    private final File dataDirectory;

    public ManifestBasedDeploymentPackageImportService(RepositoryService repositoryService, ConfigurationItemTypeDescriptorRepository typeRepository, File dataDir) {
        this.repositoryService = repositoryService;
        this.typeRepository = typeRepository;
        this.dataDirectory = dataDir;
    }

    @Override
    public String validateAndImport(String urlAsString) throws IOException, DeploymentPackageImportErrors {
        return this.validateAndImport(urlAsString, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String validateAndImport(String urlAsString, String username, String password, ConfigurationItemHandle permissionSchemeHandle) throws IOException, DeploymentPackageImportErrors {
        String string;
        Protocol oldHTTPSProtocol = Protocol.getProtocol((String)"https");
        try {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new LaxSSLProtocolSocketFactory(), 443));
            HttpClient client = new HttpClient();
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
                client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            }
            GetMethod method = new GetMethod(urlAsString);
            method.setDoAuthentication(true);
            int status = client.executeMethod((HttpMethod)method);
            if (status != 200) {
                throw new DeploymentPackageImportErrors("Can't read package from URL " + urlAsString + ". HTTP status: " + status);
            }
            HostSession localSession = Host.getLocalHost().getHostSession();
            try {
                HostFile downloadedArchive = localSession.getTempFile("downloaded", ".zip");
                HostFile expandedArchiveDir = ManifestBasedDeploymentPackageImportService.getTempDir(localSession, "expanded", ".dir");
                downloadedArchive.put((Resource)new InputStreamResource(method.getResponseBodyAsStream()));
                method.releaseConnection();
                HostFileUtils.unzip((HostFile)downloadedArchive, (HostFile)expandedArchiveDir);
                string = this.validateAndImport(expandedArchiveDir, permissionSchemeHandle);
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                localSession.close();
                throw throwable;
            }
            localSession.close();
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            Protocol.registerProtocol((String)"https", (Protocol)oldHTTPSProtocol);
            throw throwable;
        }
        Protocol.registerProtocol((String)"https", (Protocol)oldHTTPSProtocol);
        return string;
    }

    public static HostFile getTempDir(HostSession session, String prefix, String suffix) {
        HostFile tempDir = session.getTempFile(prefix, suffix);
        tempDir.delete();
        tempDir.mkdir();
        return tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateAndImport(HostFile deploymentPackageDir, ConfigurationItemHandle permissionSchemeHandle) throws DeploymentPackageImportErrors, RuntimeIOException {
        ConfigurationItemHandle applicationHandle;
        if (!deploymentPackageDir.exists()) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not exist");
        }
        if (!deploymentPackageDir.isDirectory()) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " is not a directory");
        }
        HostFile manifestFile = deploymentPackageDir.getFile("META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " has no META-INF/MANIFEST.MF file");
        }
        Manifest manifest = ManifestBasedDeploymentPackageImportService.readManifest(manifestFile);
        Attributes mainAttributes = manifest.getMainAttributes();
        String packageFormatVersion = StringUtils.trim((String)mainAttributes.getValue(PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME));
        if (packageFormatVersion == null) {
            packageFormatVersion = "unspecified";
        }
        if (!PACKAGE_FORMAT_VERSION_NUMBER.equals(packageFormatVersion)) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not have the right " + PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME + " header value (actual: " + packageFormatVersion + " expected: " + PACKAGE_FORMAT_VERSION_NUMBER + ")");
        }
        String applicationName = StringUtils.trim((String)mainAttributes.getValue(APPLICATION_ATTRIBUTE_NAME));
        if (StringUtils.isBlank((String)applicationName)) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not declare its application name using the " + APPLICATION_ATTRIBUTE_NAME + " main attribute");
        }
        String packageVersion = StringUtils.trim((String)mainAttributes.getValue(VERSION_ATTRIBUTE_NAME));
        if (StringUtils.isBlank((String)packageVersion)) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not declare its version number using the " + VERSION_ATTRIBUTE_NAME + " main attribute");
        }
        DeploymentPackage pkg = new DeploymentPackage();
        pkg.setVersion(packageVersion);
        ConfigurationItemRevision pkgRevision = new ConfigurationItemRevision(pkg);
        this.setPermissionScheme(pkgRevision, permissionSchemeHandle);
        int nrOfEntriesFound = 0;
        ConfigurationItemDescriptor deploymentPackageDescriptor = this.typeRepository.getDescriptor(DeploymentPackage.class);
        HashSet<ConfigurationItemHandle> artifactHandles = new HashSet<ConfigurationItemHandle>();
        HashSet<ConfigurationItemHandle> resourceHandles = new HashSet<ConfigurationItemHandle>();
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile dataDir = lhs.getFile(this.dataDirectory.getPath());
            for (Map.Entry<String, Attributes> each : manifest.getEntries().entrySet()) {
                String entryName = StringUtils.trim((String)each.getKey());
                Attributes entryAttributes = each.getValue();
                String entryType = StringUtils.trim((String)entryAttributes.getValue(TYPE_ATTRIBUTE_NAME));
                if (entryType == null) continue;
                ConfigurationItemDescriptor descriptor = null;
                for (ConfigurationItemDescriptor eachTD : this.typeRepository.getDescriptors()) {
                    if (!eachTD.getSimpleName().equalsIgnoreCase(entryType)) continue;
                    descriptor = eachTD;
                    break;
                }
                if (descriptor == null) {
                    throw new DeploymentPackageImportErrors("Entry " + entryName + " in deployment package " + deploymentPackageDir + " is of an unknown type: " + entryType);
                }
                if (!descriptor.getSuperClasses().contains(DeployableArtifact.class.getName())) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (ConfigurationItemPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                        String propertyName = propertyDescriptor.getName();
                        String propertyValue = StringUtils.trim((String)entryAttributes.getValue(propertyName));
                        if (propertyValue == null && propertyDescriptor.getType().equals((Object)ConfigurationItemPropertyType.LIST_OF_OBJECTS)) {
                            TreeMap values = Maps.newTreeMap();
                            for (Map.Entry<Object, Object> entry : entryAttributes.entrySet()) {
                                String key = entry.getKey().toString();
                                if (key.startsWith(propertyName + "-Entry-") && entry.getValue() != null) {
                                    values.put(key, entry.getValue().toString());
                                }
                                if (!key.startsWith(propertyName + "-EntryKey-")) continue;
                                String associatedValueKey = key.replace("-EntryKey-", "-EntryValue-");
                                String value = entryAttributes.getValue(associatedValueKey);
                                values.put(key, "[key=" + entry.getValue().toString() + " value=" + value + "]");
                            }
                            propertyValue = "[" + StringUtils.join(values.values(), (String)"") + "]";
                        }
                        if (propertyDescriptor.isRequired() && propertyValue == null) {
                            throw new DeploymentPackageImportErrors("Entry " + entryName + " in deployment package " + deploymentPackageDir + " is of a type that is not a subclass of DeployableArtifact: " + entryType + " nor is it a Middleware Resource with all its mandatory properties specified in the Manifest, at least -" + propertyName + "- is missing");
                        }
                        properties.put(propertyName.toLowerCase(), propertyValue);
                    }
                    try {
                        Object item = PropertyListConverter.convertAttributesToObject(properties, descriptor);
                        String artifactLabel = LabelGenerator.makeLabelOfApplicationVersionAndName(applicationName, packageVersion, entryName);
                        ConfigurationItemRevision artifactRevision = new ConfigurationItemRevision(item);
                        this.setPermissionScheme(artifactRevision, permissionSchemeHandle);
                        ConfigurationItemHandle resourceHandle = this.repositoryService.addConfigurationItem(artifactLabel, "", descriptor.getType(), artifactRevision);
                        resourceHandles.add(resourceHandle);
                    }
                    catch (ConversionException e) {
                        throw new DeploymentPackageImportErrors("Conversion Error :" + e);
                    }
                }
                boolean isFolderArtifactType = descriptor.getSuperClasses().contains(Folder.class.getName());
                HostFile packageArtifact = deploymentPackageDir.getFile(entryName);
                if (isFolderArtifactType) {
                    if (!packageArtifact.isDirectory()) {
                        throw new DeploymentPackageImportErrors("Entry " + entryName + " in deployment package " + deploymentPackageDir + " is a type that is a subclass of " + Folder.class.getName() + " but it is NOT a folder");
                    }
                } else if (packageArtifact.isDirectory()) {
                    throw new DeploymentPackageImportErrors("Entry " + entryName + " in deployment package " + deploymentPackageDir + " is NOT of a type that is a subclass of " + Folder.class.getName() + " but it is a folder");
                }
                DeployableArtifact artifact = (DeployableArtifact)descriptor.newInstance();
                String artifactLabel = LabelGenerator.makeLabelOfApplicationVersionAndName(applicationName, packageVersion, entryName);
                ConfigurationItemRevision artifactRevision = new ConfigurationItemRevision(artifact);
                this.setPermissionScheme(artifactRevision, permissionSchemeHandle);
                ConfigurationItemHandle artifactHandle = this.repositoryService.addConfigurationItem(artifactLabel, "", descriptor.getType(), artifactRevision);
                String artifactFilename = artifactHandle.getId() + ".dat";
                HostFile importedArtifact = dataDir.getFile(artifactFilename);
                try {
                    HostFileUtils.copy((HostFile)packageArtifact, (HostFile)importedArtifact);
                }
                catch (RuntimeIOException exc) {
                    throw new DeploymentPackageImportErrors("Cannot read artifact " + entryName + " from deployment package " + deploymentPackageDir + ": " + (Object)((Object)exc));
                }
                artifact.setLocation(importedArtifact.getPath());
                if (descriptor.getSuperClasses().contains(NamedDeployableArtifact.class.getName())) {
                    String artifactName = StringUtils.trim((String)entryAttributes.getValue(NAME_ATTRIBUTE_NAME));
                    ((NamedDeployableArtifact)artifact).setName(StringUtils.isNotBlank((String)artifactName) ? artifactName : ManifestBasedDeploymentPackageImportService.generateDefaultName(packageArtifact));
                }
                artifactRevision.setDetailsObject(artifact);
                artifactHandles.add(artifactHandle);
                ++nrOfEntriesFound;
            }
            Object var38_42 = null;
        }
        catch (Throwable throwable) {
            Object var38_43 = null;
            lhs.close();
            throw throwable;
        }
        lhs.close();
        if (nrOfEntriesFound == 0) {
            throw new DeploymentPackageImportErrors("Application package " + deploymentPackageDir + " does not contain any artifacts");
        }
        Triple<ConfigurationItemRevision, Change, AccessControlEntry> existingAplicationRevisionInfo = this.repositoryService.findDesignRevisionByLabel(applicationName);
        if (existingAplicationRevisionInfo != null) {
            applicationHandle = existingAplicationRevisionInfo.getFirst().getHandle();
        } else {
            Application newApplication = new Application();
            ConfigurationItemRevision newApplicationRevision = new ConfigurationItemRevision(newApplication);
            this.setPermissionScheme(newApplicationRevision, permissionSchemeHandle);
            applicationHandle = this.repositoryService.addConfigurationItem(applicationName, "", newApplication.getClass().getName(), newApplicationRevision);
        }
        String deployableArtifactsPropertyName = this.getDeployableArtifactPropertyName(deploymentPackageDescriptor);
        pkgRevision.addRelatedCiHandles(deployableArtifactsPropertyName, artifactHandles);
        String resourceArtifactsPropertyName = this.getResourcePropertyName(deploymentPackageDescriptor);
        pkgRevision.addRelatedCiHandles(resourceArtifactsPropertyName, resourceHandles);
        String applicationPropertyName = this.getApplicationPropertyName(deploymentPackageDescriptor);
        pkgRevision.addRelatedCiHandle(applicationPropertyName, applicationHandle);
        String packageLabel = applicationName + NAMESPACE_SEPARATOR + packageVersion;
        this.repositoryService.addConfigurationItem(packageLabel, "", pkg.getClass().getName(), pkgRevision);
        return packageLabel;
    }

    private void setPermissionScheme(ConfigurationItemRevision theRevision, ConfigurationItemHandle permissionSchemeHandle) {
        if (permissionSchemeHandle != null) {
            theRevision.setPermissionSchemeHandle(permissionSchemeHandle);
        }
    }

    private static Manifest readManifest(HostFile manifestFile) {
        Manifest manifest;
        InputStream in = manifestFile.get();
        try {
            try {
                manifest = new Manifest(in);
            }
            catch (IOException exception) {
                throw new RuntimeIOException("Cannot read manifest file " + manifestFile, (Throwable)exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return manifest;
    }

    private String getDeployableArtifactPropertyName(ConfigurationItemDescriptor deploymentPackageDescriptor) {
        String deployableArtifactsPropertyName = null;
        for (ConfigurationItemPropertyDescriptor configurationItemPropertyDescriptor : deploymentPackageDescriptor.getPropertyDescriptors()) {
            if (configurationItemPropertyDescriptor.getCollectionMemberClass() == null || !configurationItemPropertyDescriptor.getCollectionMemberClass().equals(DeployableArtifact.class)) continue;
            deployableArtifactsPropertyName = configurationItemPropertyDescriptor.getName();
        }
        return deployableArtifactsPropertyName;
    }

    private String getResourcePropertyName(ConfigurationItemDescriptor deploymentPackageDescriptor) {
        String deployableArtifactsPropertyName = null;
        for (ConfigurationItemPropertyDescriptor configurationItemPropertyDescriptor : deploymentPackageDescriptor.getPropertyDescriptors()) {
            if (configurationItemPropertyDescriptor.getCollectionMemberClass() == null || !configurationItemPropertyDescriptor.getCollectionMemberClass().equals(MiddlewareResource.class)) continue;
            deployableArtifactsPropertyName = configurationItemPropertyDescriptor.getName();
        }
        return deployableArtifactsPropertyName;
    }

    private String getApplicationPropertyName(ConfigurationItemDescriptor deploymentPackageDescriptor) {
        return "application";
    }

    private static String generateDefaultName(HostFile packageArtifact) {
        return FilenameUtils.getBaseName((String)packageArtifact.getName());
    }

    @Override
    public Collection<DeploymentPackageLocation> getDeploymentPackageList(String location) {
        File[] listFiles;
        ArrayList<DeploymentPackageLocation> deploymentPackageLocation = new ArrayList<DeploymentPackageLocation>();
        if (location == null) {
            return deploymentPackageLocation;
        }
        File componentDir = new File(location);
        if (!componentDir.exists()) {
            return deploymentPackageLocation;
        }
        for (File applicationDir : listFiles = componentDir.listFiles()) {
            if (!applicationDir.isDirectory() || applicationDir.listFiles() == null || applicationDir.getName().startsWith(".")) continue;
            for (File deploymentPackageDir : applicationDir.listFiles()) {
                if (!deploymentPackageDir.isDirectory() || !this.isValidDirectoryName(deploymentPackageDir)) continue;
                deploymentPackageLocation.add(new DeploymentPackageLocation(deploymentPackageDir));
            }
        }
        return deploymentPackageLocation;
    }

    private boolean isValidDirectoryName(File dir) {
        if (dir == null) {
            return false;
        }
        String name = dir.getName();
        return this.startsWithNumber(name);
    }

    private boolean startsWithNumber(String name) {
        return StringUtils.isNotBlank((String)name) && CharUtils.isAsciiNumeric((char)name.charAt(0));
    }
}

