/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.reporting.organizers;

import com.xebia.ad.reporting.organizers.ReportDataOrganizer;
import com.xebia.ad.reporting.transformers.ReportPropertyTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedReportDataOrganizer
implements ReportDataOrganizer {
    private List<Map<Serializable, Serializable>> data;
    private String seriesProperty;
    private String groupProperty;
    private List<List<Map<Serializable, Serializable>>> groupedSeriesData = new ArrayList<List<Map<Serializable, Serializable>>>();
    private ReportPropertyTransformer propertyTransformer;

    public MapBasedReportDataOrganizer(List<Map<Serializable, Serializable>> data, String seriesProperty, ReportPropertyTransformer propertyTransformer) {
        this.data = data;
        this.seriesProperty = seriesProperty;
        this.propertyTransformer = propertyTransformer;
    }

    public MapBasedReportDataOrganizer(List<Map<Serializable, Serializable>> data, String seriesProperty, String groupProperty, ReportPropertyTransformer propertyTransformer) {
        this.data = data;
        this.seriesProperty = seriesProperty;
        this.groupProperty = groupProperty;
        this.propertyTransformer = propertyTransformer;
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getCountedGroupedData() {
        this.process();
        return this.groupedSeriesData;
    }

    private void process() {
        List<Object> uniqueGroups;
        if (this.isGroupPropertySpecified()) {
            uniqueGroups = this.getUniqueProperties(this.groupProperty, "group");
        } else {
            uniqueGroups = new ArrayList<String>();
            uniqueGroups.add("");
        }
        List<Serializable> uniqueSeries = this.getUniqueProperties(this.seriesProperty, "series");
        for (Serializable serializable : uniqueGroups) {
            ArrayList groupData = new ArrayList();
            for (Serializable eachSeries : uniqueSeries) {
                List<Map<Serializable, Serializable>> seriesData = this.getFileteredData(serializable, eachSeries);
                HashMap<String, Serializable> datapoint = new HashMap<String, Serializable>();
                datapoint.put("group", serializable);
                Serializable propertyValue = this.propertyTransformer != null ? this.propertyTransformer.originalPropertyValue(eachSeries) : eachSeries;
                datapoint.put("series", propertyValue);
                datapoint.put("totalNo", Integer.valueOf(seriesData.size()));
                groupData.add(datapoint);
            }
            this.groupedSeriesData.add(groupData);
        }
    }

    private List<Map<Serializable, Serializable>> getFileteredData(Serializable eachGroup, Serializable eachSeries) {
        ArrayList<Map<Serializable, Serializable>> filteredData = new ArrayList<Map<Serializable, Serializable>>();
        for (Map<Serializable, Serializable> objMap : this.data) {
            Serializable seriesValue;
            Serializable groupValue;
            if (this.isGroupPropertySpecified() && !(groupValue = objMap.get(this.groupProperty)).equals(eachGroup) || !(seriesValue = this.propertyTransformer != null ? this.propertyTransformer.transformPropertyValue(objMap.get(this.seriesProperty)) : objMap.get(this.seriesProperty)).equals(eachSeries)) continue;
            filteredData.add(objMap);
        }
        return filteredData;
    }

    private List<Serializable> getUniqueProperties(String property, String propertyType) {
        ListOrderedSet uniquePropertiesSet = new ListOrderedSet();
        for (Map<Serializable, Serializable> objMap : this.data) {
            Object transformedValue = this.getValueOfProperty(objMap, property, propertyType);
            uniquePropertiesSet.add(transformedValue);
        }
        return uniquePropertiesSet.asList();
    }

    private Object getValueOfProperty(Map<Serializable, Serializable> obj, String property, String propertyType) {
        Serializable transformedValue = null;
        Serializable value = obj.get(property);
        transformedValue = propertyType == "group" ? value : (this.propertyTransformer != null ? this.propertyTransformer.transformPropertyValue(value) : value);
        return transformedValue;
    }

    public boolean isGroupPropertySpecified() {
        return !StringUtils.isEmpty((String)this.groupProperty);
    }

    public void setPropertyTransformer(ReportPropertyTransformer propertyTransformer) {
        this.propertyTransformer = propertyTransformer;
    }
}

