/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.factory;

import com.google.common.base.Preconditions;
import com.xebia.ad.conversion.ConversionException;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.factory.CiDetailsDeserializerHolder;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class CiDetailsDeserializer {
    private final ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private final List<CiDeserializationProcessor> deserializationProcessors;
    private final Logger log = Logger.getLogger(ConfigurationItemRevision.class);

    public CiDetailsDeserializer(ConfigurationItemTypeDescriptorRepository descriptorRepository, CiDeserializationProcessor ... deserializationProcessors) {
        this.descriptorRepository = (ConfigurationItemTypeDescriptorRepository)Preconditions.checkNotNull((Object)descriptorRepository);
        this.deserializationProcessors = (List)Preconditions.checkNotNull(Arrays.asList(deserializationProcessors));
    }

    public Object deserialize(ConfigurationItemRevision revision, String typeName, String serializedDetails, RepositoryView view) {
        ConfigurationItemDescriptor descriptor = this.descriptorRepository.getDescriptor(typeName);
        if (descriptor == null) {
            throw new IllegalStateException("Cannot deserialize details for " + typeName + " because it is an unknown type");
        }
        Object target = descriptor.newInstance();
        try {
            for (CiDeserializationProcessor processor : this.deserializationProcessors) {
                processor.process(revision, target, descriptor, serializedDetails, view);
            }
        }
        catch (ConversionException exception) {
            this.log.error((Object)("Cannot deserialize details for " + typeName + ". Creating empty instance"), (Throwable)exception);
            target = descriptor.newInstance();
        }
        return target;
    }

    public static CiDetailsDeserializer getInstance() {
        return CiDetailsDeserializerHolder.getInstance();
    }

    public static interface CiDeserializationProcessor {
        public void process(ConfigurationItemRevision var1, Object var2, ConfigurationItemDescriptor var3, String var4, RepositoryView var5) throws ConversionException;
    }
}

