/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.upload;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactUploadServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(ArtifactUploadServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        logger.debug((Object)("Request received. Uri: " + uri));
        if (uri != null && uri.equals("/artifactupload/upload.do") && ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            logger.debug((Object)"Proper Uri and is a multi part content POST, will try to upload");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            int yourMaxRequestSize = Integer.MAX_VALUE;
            upload.setSizeMax((long)yourMaxRequestSize);
            List items = null;
            try {
                items = upload.parseRequest(req);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
            String filename = this.findFilename(items);
            logger.debug((Object)("Recognized file named " + filename + " trying to copy it to server..."));
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                this.processUploadedFile(item, filename);
            }
        }
        resp.setStatus(200);
    }

    private String findFilename(List<FileItem> items) {
        Iterator<FileItem> iter = items.iterator();
        String filename = null;
        while (iter.hasNext()) {
            FileItem item = iter.next();
            if (!item.isFormField() || (filename = this.processFormField(item)) == null) continue;
            return filename;
        }
        return filename;
    }

    private String processFormField(FileItem item) {
        if (item.isFormField()) {
            String name = item.getFieldName();
            String value = item.getString();
            if (name != null && name.equals("Filename")) {
                return value;
            }
        }
        return null;
    }

    private void processUploadedFile(FileItem item, String filenameToWriteTo) {
        if (!item.isFormField()) {
            File uploadedFile = new File(filenameToWriteTo);
            if (uploadedFile.exists()) {
                logger.debug((Object)("File " + filenameToWriteTo + " already existed. WARNING: Will be overwriten"));
                uploadedFile.delete();
            }
            try {
                item.write(uploadedFile);
                logger.debug((Object)("File " + filenameToWriteTo + " written"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

