/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.ReleaseInfo;
import com.xebia.ad.Server;
import com.xebia.ad.cli.Interpreter;
import com.xebia.ad.setup.Setup;
import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.security.context.SecurityContextHolder;

public class DeployIt {
    private static final String UNKNOWN_FIRST_ARGUMENT = "Please supply one of the following arguments: -server, -cli, -setup";
    private static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";

    public static void main(String[] args) {
        File log4jConfiguration = new File("log4j.properties");
        if (log4jConfiguration.exists()) {
            System.setProperty("log4j.configuration", "file:" + log4jConfiguration.getName());
        }
        SecurityContextHolder.setStrategyName((String)MODE_INHERITABLETHREADLOCAL);
        Logger logger = Logger.getLogger(DeployIt.class);
        logger.setLevel(Level.INFO);
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        logger.info((Object)("Deployit version " + releaseInfo.getVersion() + " (build " + releaseInfo.getBuild() + " at " + releaseInfo.getDate() + ")"));
        logger.info((Object)"(c) 2008-2010 Xebialabs.com");
        if (!releaseInfo.isEnterpriseEdition()) {
            System.out.println("__________                                           .__    ___________   .___.__   __  .__               ");
            System.out.println("\\______   \\  ____ _______ ______ ____   ____ _____   |  |   \\_   _____/ __| _/|__|_/  |_|__| ____   ____  ");
            System.out.println(" |     ___/_/ __ \\\\_  __ |  ___//  _ \\ /    \\\\__  \\  |  |    |    __)_ / __ | |  |\\   __\\  |/  _ \\ /    \\ ");
            System.out.println(" |    |    \\  ___/ |  | \\|___ \\(  <_> )   |  \\/ __ \\_|  |__  |        | /_/ | |  | |  | |  (  <_> )   |  \\");
            System.out.println(" |____|     \\___  >|__| /____  >\\____/|___|  (____  /|____/ /_______  |____ | |__| |__| |__|\\____/|___|  /");
            System.out.println("                \\/           \\/            \\/     \\/                \\/     \\/                          \\/ ");
        }
        if (args.length == 0) {
            DeployIt.reportUnknownArgument(logger);
        }
        DeployItConfiguration configuration = new DeployItConfiguration();
        if (args[0].equals("-server")) {
            if (!configuration.exists()) {
                logger.error((Object)"Configuration not found...");
                DeployIt.startSetup(args, logger);
            }
            DeployIt.startServer(args, logger);
        } else if (args[0].equals("-cli")) {
            DeployIt.startCli(args, logger);
        } else if (args[0].equals("-setup")) {
            DeployIt.startSetup(args, logger);
        } else {
            DeployIt.reportUnknownArgument(logger);
        }
    }

    private static void startServer(String[] args, Logger logger) {
        logger.info((Object)"Starting server...");
        Server.main((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
    }

    private static void startCli(String[] args, Logger logger) {
        logger.info((Object)"Starting the command line interpreter...");
        Interpreter.main((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
    }

    private static void startSetup(String[] args, Logger logger) {
        logger.info((Object)"Starting setup...");
        Setup.main((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length));
    }

    private static void reportUnknownArgument(Logger logger) {
        logger.error((Object)UNKNOWN_FIRST_ARGUMENT);
        System.exit(1);
    }
}

