/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.support;

import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import org.apache.commons.lang.StringUtils;

public class LabelGenerator {
    public static final String NAMESPACE_SEPARATOR = "/";

    public static String generateLabelFromTypeDescriptor(BaseConfigurationItem item, ConfigurationItemDescriptor descriptor) {
        ConfigurationItemPropertyDescriptor propertyDescriptor = LabelGenerator.findIdentifyingPropertyDescriptor(descriptor);
        if (propertyDescriptor != null) {
            return (String)propertyDescriptor.getPropertyValueFromConfigurationItem((Object)item);
        }
        String type = descriptor.getType();
        String ciName = type.substring(type.lastIndexOf(".") + 1);
        return StringUtils.uncapitalize((String)ciName);
    }

    private static ConfigurationItemPropertyDescriptor findIdentifyingPropertyDescriptor(ConfigurationItemDescriptor descriptor) {
        ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor("name");
        if (propertyDescriptor == null) {
            for (ConfigurationItemPropertyDescriptor eachPropertyDescriptor : descriptor.getPropertyDescriptors()) {
                if (!eachPropertyDescriptor.isIdentifying()) continue;
                propertyDescriptor = eachPropertyDescriptor;
                break;
            }
        }
        return propertyDescriptor;
    }

    public static String makeLabelOfApplicationVersionAndName(String applicationName, String packageVersion, String entryName) {
        return LabelGenerator.makePrefixOfApplicationAndVersion(applicationName, packageVersion) + entryName;
    }

    public static String makeApplicationAndVersionLessLabel(ConfigurationItemHandle packageHandle, ConfigurationItemHandle packageMemberHandle, RepositoryView view) {
        if (packageHandle != null && packageMemberHandle != null) {
            ConfigurationItemRevision deploymentPackageRevision = view.getViewRevision(packageHandle);
            DeploymentPackage deploymentPackage = (DeploymentPackage)deploymentPackageRevision.getDetailsObject(view);
            ConfigurationItemHandle applicationHandle = deploymentPackageRevision.getRelatedCiHandle("application");
            String prefix = LabelGenerator.makePrefixOfApplicationAndVersion(applicationHandle.getLabel(), deploymentPackage.getVersion());
            if (packageMemberHandle.getLabel().startsWith(prefix)) {
                return packageMemberHandle.getLabel().substring(prefix.length());
            }
        }
        return packageMemberHandle.getLabel();
    }

    private static String makePrefixOfApplicationAndVersion(String application, String version) {
        return application + NAMESPACE_SEPARATOR + version + NAMESPACE_SEPARATOR;
    }

    public static String addOrUpgradeNumberOnLabel(String label) {
        int number = LabelGenerator.getNumber(label);
        String labelWithoutNumber = LabelGenerator.stripNumber(label, number);
        return labelWithoutNumber + "(" + (number + 1) + ")";
    }

    private static String stripNumber(String label, int number) {
        if (number == 0) {
            return label;
        }
        String lastPart = "(" + number + ")";
        return label.substring(0, label.length() - lastPart.length());
    }

    private static int getNumber(String label) {
        int lastOpeningBracketIndex = label.lastIndexOf(40);
        int lastClosingBracketIndex = label.lastIndexOf(41);
        if (lastOpeningBracketIndex == -1 || lastClosingBracketIndex == -1) {
            return 0;
        }
        String possibleNumber = label.substring(lastOpeningBracketIndex + 1, lastClosingBracketIndex);
        try {
            return Integer.parseInt(possibleNumber);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

