
    create table CHANGEPLAN (
        ID integer generated by default as identity (start with 1),
        DESCRIPTION varchar(255),
        END_OF_EXECUTION timestamp,
        RESOLUTION_ERROR varchar(255),
        START_OF_EXECUTION timestamp,
        STATE varchar(255),
        USERNAME varchar(255),
        WARNINGS longvarchar,
        primary key (ID)
    );

    create table CHANGES (
        ID integer generated by default as identity (start with 1),
        CHANGEPLAN_ID integer,
        HANDLE_ID integer,
        NEW_REVISION_ID integer,
        OLD_REVISION_ID integer,
        primary key (ID)
    );

    create table CI_HANDLE (
        ID integer generated by default as identity (start with 1),
        DESCRIPTION longvarchar,
        LABEL varchar(255),
        TYPE varchar(255),
        ACTUAL_REVISION_ID integer,
        primary key (ID)
    );

    create table CI_REVISION (
        ID integer generated by default as identity (start with 1),
        DETAILS longvarchar,
        HANDLE_ID integer,
        PERMISSION_SCHEME_ID integer,
        primary key (ID)
    );

    create table DEPLOYITUSER (
        ID integer generated by default as identity (start with 1),
        PREFERENCES varbinary(255),
        USERNAME varchar(255),
        primary key (ID),
        unique (USERNAME)
    );

    create table NAMED_CI_RELATION (
        ID integer generated by default as identity (start with 1),
        PROPERTY_NAME varchar(255),
        OWNING_REVISION_ID integer,
        TARGET_HANDLE_ID integer,
        primary key (ID)
    );

    create table STEP (
        STEP_ID integer generated by default as identity (start with 1),
        DEFININGFILE varchar(255),
        DESCRIPTION varchar(255),
        LANGUAGE varchar(255),
        LOG longvarchar,
        POS integer,
        DETAILS longvarbinary,
        STATE varchar(255),
        CHANGEPLAN_ID integer,
        primary key (STEP_ID)
    );

    create index CHANGEPLAN_USERNAME_IX on CHANGEPLAN (USERNAME);

    create index CHANGEPLAN_STATE_IX on CHANGEPLAN (STATE);

    create index CHANGES_CHANGEPLAN on CHANGES (CHANGEPLAN_ID);

    create index CHANGES_HANDLE on CHANGES (HANDLE_ID);

    alter table CHANGES 
        add constraint FK_CHANGES_OLD_REVISION 
        foreign key (OLD_REVISION_ID) 
        references CI_REVISION;

    alter table CHANGES 
        add constraint FK_CHANGES_NEW_REVISION 
        foreign key (NEW_REVISION_ID) 
        references CI_REVISION;

    alter table CHANGES 
        add constraint FK_CHANGES_CHANGEPLAN 
        foreign key (CHANGEPLAN_ID) 
        references CHANGEPLAN;

    alter table CHANGES 
        add constraint FK_CHANGES_HANDLE 
        foreign key (HANDLE_ID) 
        references CI_HANDLE;

    create index CI_HANDLE_ACTUAL_REVISION_IX on CI_HANDLE (ACTUAL_REVISION_ID);

    create index CI_HANDLE_LABEL_UN on CI_HANDLE (LABEL);

    alter table CI_HANDLE 
        add constraint CI_HANDLE_ACTUAL_REVISION_FK 
        foreign key (ACTUAL_REVISION_ID) 
        references CI_REVISION;

    alter table CI_REVISION 
        add constraint CI_REVISION_PERMISSION_FK 
        foreign key (PERMISSION_SCHEME_ID) 
        references CI_HANDLE;

    alter table CI_REVISION 
        add constraint FK_CI_REVISION_HANDLE 
        foreign key (HANDLE_ID) 
        references CI_HANDLE;

    alter table NAMED_CI_RELATION 
        add constraint FKAB16858FF031847D 
        foreign key (TARGET_HANDLE_ID) 
        references CI_HANDLE;

    alter table NAMED_CI_RELATION 
        add constraint FKAB16858F792C2768 
        foreign key (OWNING_REVISION_ID) 
        references CI_REVISION;

    alter table STEP 
        add constraint FK_STEP_CHANGEPLAN 
        foreign key (CHANGEPLAN_ID) 
        references CHANGEPLAN;
