
    create table CHANGEPLAN (
        ID number(10,0) not null,
        END_OF_EXECUTION date,
        RESOLUTION_ERROR varchar2(255),
        START_OF_EXECUTION date,
        STATE varchar2(255),
        USERNAME varchar2(255),
        primary key (ID)
    );

    create table CHANGES (
        ID number(10,0) not null,
        CHANGEPLAN_ID number(10,0),
        HANDLE_ID number(10,0),
        NEW_REVISION_ID number(10,0),
        OLD_REVISION_ID number(10,0),
        primary key (ID)
    );

    create table CI_HANDLE (
        ID number(10,0) not null,
        DESCRIPTION clob,
        LABEL varchar2(255),
        TYPE varchar2(255),
        ACTUAL_REVISION_ID number(10,0),
        primary key (ID)
    );

    create table CI_REVISION (
        ID number(10,0) not null,
        DETAILS clob,
        HANDLE_ID number(10,0),
        PERMISSION_SCHEME_ID number(10,0),
        primary key (ID)
    );

    create table NAMED_CI_RELATION (
        ID number(10,0) not null,
        PROPERTY_NAME varchar2(255),
        OWNING_REVISION_ID number(10,0),
        TARGET_HANDLE_ID number(10,0),
        primary key (ID)
    );

    create table STEP (
        STEP_ID number(10,0) not null,
        DEFININGFILE varchar2(255),
        DESCRIPTION varchar2(255),
        LANGUAGE varchar2(255),
        LOG clob,
        POS number(10,0),
        DETAILS blob,
        STATE varchar2(255),
        CHANGEPLAN_ID number(10,0),
        primary key (STEP_ID)
    );

    create index CHANGEPLAN_USERNAME_IX on CHANGEPLAN (USERNAME);

    create index CHANGEPLAN_STATE_IX on CHANGEPLAN (STATE);

    create index CHANGES_CHANGEPLAN on CHANGES (CHANGEPLAN_ID);

    create index CHANGES_HANDLE on CHANGES (HANDLE_ID);

    alter table CHANGES 
        add constraint FK_CHANGES_OLD_REVISION 
        foreign key (OLD_REVISION_ID) 
        references CI_REVISION;

    alter table CHANGES 
        add constraint FK_CHANGES_NEW_REVISION 
        foreign key (NEW_REVISION_ID) 
        references CI_REVISION;

    alter table CHANGES 
        add constraint FK_CHANGES_CHANGEPLAN 
        foreign key (CHANGEPLAN_ID) 
        references CHANGEPLAN;

    alter table CHANGES 
        add constraint FK_CHANGES_HANDLE 
        foreign key (HANDLE_ID) 
        references CI_HANDLE;

    create index CI_HANDLE_ACTUAL_REVISION_IX on CI_HANDLE (ACTUAL_REVISION_ID);

    create index CI_HANDLE_LABEL_UN on CI_HANDLE (LABEL);

    alter table CI_HANDLE 
        add constraint CI_HANDLE_ACTUAL_REVISION_FK 
        foreign key (ACTUAL_REVISION_ID) 
        references CI_REVISION;

    alter table CI_REVISION 
        add constraint CI_REVISION_PERMISSION_FK 
        foreign key (PERMISSION_SCHEME_ID) 
        references CI_HANDLE;

    alter table CI_REVISION 
        add constraint FK_CI_REVISION_HANDLE 
        foreign key (HANDLE_ID) 
        references CI_HANDLE;

    alter table NAMED_CI_RELATION 
        add constraint FKAB16858FF031847D 
        foreign key (TARGET_HANDLE_ID) 
        references CI_HANDLE;

    alter table NAMED_CI_RELATION 
        add constraint FKAB16858F792C2768 
        foreign key (OWNING_REVISION_ID) 
        references CI_REVISION;

    alter table STEP 
        add constraint FK_STEP_CHANGEPLAN 
        foreign key (CHANGEPLAN_ID) 
        references CHANGEPLAN;

    create sequence hibernate_sequence;
