/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.integration.test;

import com.xebialabs.deployit.DeployItConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.integration.test.NiceParameterizedNames;
import com.xebialabs.deployit.integration.test.support.TemporaryDirectoryHolder;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@RunWith(value=NiceParameterizedNames.class)
public class DeployitIntegrationTest {
    private static final String SETUP_FILE = "setUp.py";
    private static final String TEARDOWN_FILE = "tearDown.py";
    private static final String BASE_TEST_DIR = "src/test/jython";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static File repositoryHomeDir;
    Interpreter interpreter;
    private File scriptFile;
    private static String filesToRunPattern;
    private static Cli cli;
    private static final Logger logger;

    public DeployitIntegrationTest(File scriptFileToRun) {
        this.scriptFile = scriptFileToRun;
    }

    @Parameterized.Parameters
    public static List<Object[]> scriptsToRun() {
        String baseDir = System.getProperty("jythonTestBaseDir", BASE_TEST_DIR);
        logger.info("Running all tests in {}", (Object)baseDir);
        ArrayList<Object[]> targets = new ArrayList<Object[]>();
        DeployitIntegrationTest.scriptDir(new File(baseDir), targets);
        return targets;
    }

    private static void scriptDir(File testsDir, List<Object[]> targets) {
        if (testsDir.exists()) {
            File[] scriptFiles;
            for (File eachFile : scriptFiles = testsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isDirectory = new File(dir, name).isDirectory();
                    boolean isTest = name.endsWith(".py") && !DeployitIntegrationTest.SETUP_FILE.equals(name) && !DeployitIntegrationTest.TEARDOWN_FILE.equals(name);
                    return isDirectory || isTest;
                }
            })) {
                if (eachFile.isDirectory()) {
                    DeployitIntegrationTest.scriptDir(eachFile, targets);
                    continue;
                }
                DeployitIntegrationTest.addTarget(targets, eachFile);
            }
        }
    }

    private static void addTarget(List<Object[]> targets, File eachFile) {
        logger.info("Adding testcase for {}", (Object)eachFile);
        targets.add(new Object[]{eachFile});
    }

    @BeforeClass
    public static void init() throws Exception {
        DeployitIntegrationTest.setupJcrRepository();
        DeployitIntegrationTest.cleanupTaskBackup();
        Server.start((DeployitOptions)new DeployitOptions());
        DeployItConfiguration loadForUse = DeployItConfiguration.loadForUse();
        CliOptions options = new CliOptions();
        options.setHost("localhost");
        options.setPort(loadForUse.getHttpPort());
        options.setExposeProxies(true);
        options.setUsername("admin");
        options.setPassword("admin");
        cli = new Cli(options);
    }

    private static void cleanupTaskBackup() {
        File recoveryFile = new File("recovery.dat");
        if (recoveryFile.exists()) {
            Assert.assertThat((Object)recoveryFile.delete(), (Matcher)Is.is((Object)true));
        }
    }

    private static void setupJcrRepository() throws Exception {
        repositoryHomeDir = new File("repository");
        FileUtils.deleteDirectory((File)repositoryHomeDir);
        String homeDirAbsolutePath = repositoryHomeDir.getAbsolutePath();
        JackrabbitRepositoryFactoryBean repositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        repositoryFactoryBean.setConfiguration((Resource)new ClassPathResource("jackrabbit-repository.xml"));
        repositoryFactoryBean.setHomeDir((Resource)new FileSystemResource(homeDirAbsolutePath));
        repositoryFactoryBean.setCreateHomeDirIfNotExists(true);
        repositoryFactoryBean.afterPropertiesSet();
        repositoryFactoryBean.configureJcrRepositoryForDeployit();
        repositoryFactoryBean.destroy();
    }

    @AfterClass
    public static void shutdown() {
        Server.requestShutdown();
    }

    @Test
    public void testCliScripts() throws Exception {
        TemporaryDirectoryHolder.init(this.temporaryFolder.getRoot());
        logger.info("Executing script file " + this.scriptFile.getName());
        try {
            this.interpreter.evaluate((Reader)new FileReader(this.scriptFile));
        }
        catch (Exception e) {
            logger.error("Exception while executing script " + this.scriptFile, (Throwable)e);
            throw new Exception("Errors found during executing " + this.scriptFile.getName(), e);
        }
        finally {
            TemporaryDirectoryHolder.destroy();
        }
    }

    @Before
    public void setupInterpreterAndCheckCleanRepository() throws IOException, ScriptException {
        this.interpreter = cli.getNewInterpreter();
        this.checkClean();
        this.scanForFileInParentDirectoriesAndExecute(SETUP_FILE, this.scriptFile.getParentFile());
    }

    private void scanForFileInParentDirectoriesAndExecute(String fileNameToScanUpFor, File parentDir) throws ScriptException, FileNotFoundException {
        File setUp = new File(parentDir, fileNameToScanUpFor);
        logger.info(parentDir + ": " + setUp);
        String lastPartOfBaseTestDir = BASE_TEST_DIR.substring(BASE_TEST_DIR.lastIndexOf(47) + 1);
        while (!setUp.exists()) {
            logger.info(parentDir.getAbsolutePath());
            if (parentDir.getAbsolutePath().endsWith(lastPartOfBaseTestDir)) break;
            parentDir = parentDir.getParentFile();
            setUp = new File(parentDir, SETUP_FILE);
            logger.info(parentDir + ": " + setUp);
        }
        if (setUp.exists()) {
            this.interpreter.evaluate((Reader)new FileReader(setUp));
        }
    }

    private void checkClean() throws ScriptException, IOException {
        this.interpreter.evaluate((Reader)new InputStreamReader(new ClassPathResource("checkClean.py").getInputStream()));
    }

    @After
    public void tearDown() throws ScriptException, IOException {
        this.scanForFileInParentDirectoriesAndExecute(TEARDOWN_FILE, this.scriptFile.getParentFile());
    }

    static {
        filesToRunPattern = System.getProperty("DeployitIntegrationTest.filesToRunRegExpPattern", ".*\\.py");
        logger = LoggerFactory.getLogger(DeployitIntegrationTest.class);
    }
}

