/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.integration.test;

import com.google.common.io.Files;
import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.event.Event;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.integration.test.NiceParameterizedNames;
import com.xebialabs.deployit.integration.test.support.TemporaryDirectoryHolder;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@RunWith(value=NiceParameterizedNames.class)
public class DeployitIntegrationTest {
    private static final String SETUP_FILE = "setUp.py";
    private static final String TEARDOWN_FILE = "tearDown.py";
    private static final String BASE_TEST_DIR = "src/test/jython/";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static File repositoryHomeDir;
    Interpreter interpreter;
    private File scriptFile;
    private static String testsToRunRegExpPattern;
    private static Pattern testsToRunPattern;
    private static Cli cli;
    private static final Logger logger;

    public DeployitIntegrationTest(File file) {
        this.scriptFile = file;
    }

    @Parameterized.Parameters
    public static List<Object[]> scriptsToRun() {
        String string = System.getProperty("jythonTestBaseDir", BASE_TEST_DIR);
        logger.info("Running all tests in {}", (Object)string);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        DeployitIntegrationTest.scriptDir(new File(string), arrayList);
        return arrayList;
    }

    private static void scriptDir(File file, List<Object[]> list) {
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    boolean bl = new File(file, string).isDirectory();
                    boolean bl2 = DeployitIntegrationTest.SETUP_FILE.equals(string) || DeployitIntegrationTest.TEARDOWN_FILE.equals(string);
                    boolean bl3 = DeployitIntegrationTest.checkExtension(string, ".py") || DeployitIntegrationTest.checkExtension(string, ".cli");
                    return bl || bl3 && !bl2;
                }
            })) {
                if (file2.isDirectory()) {
                    DeployitIntegrationTest.scriptDir(file2, list);
                    continue;
                }
                DeployitIntegrationTest.addTarget(list, file2);
            }
        }
    }

    private static boolean checkExtension(String string, String string2) {
        return string.endsWith(string2) || string.endsWith(string2 + "ignore");
    }

    private static void addTarget(List<Object[]> list, File file) {
        if (testsToRunPattern.matcher(file.getName()).matches()) {
            logger.info("Adding testcase for {}", (Object)file);
            list.add(new Object[]{file, !file.getName().endsWith("ignore")});
        } else {
            logger.info("Ignoring testcase for {}", (Object)file);
        }
    }

    @BeforeClass
    public static void init() throws Exception {
        DeployitConfiguration.load();
        DeployitIntegrationTest.setupJcrRepository();
        DeployitIntegrationTest.cleanupTaskBackup();
        DeployitOptions deployitOptions = new DeployitOptions();
        deployitOptions.setTestModeEnabled(true);
        Server.start((DeployitOptions)deployitOptions);
        CliOptions cliOptions = new CliOptions();
        cliOptions.setHost("localhost");
        cliOptions.setPort(DeployitConfiguration.getInstance().getHttpPort());
        cliOptions.setExposeProxies(true);
        cliOptions.setUsername("admin");
        cliOptions.setPassword("admin");
        cli = new Cli(cliOptions);
    }

    private static void cleanupTaskBackup() {
        File file = new File("recovery.dat");
        if (file.exists()) {
            Assert.assertThat((Object)file.delete(), (Matcher)Is.is((Object)true));
        }
    }

    private static void setupJcrRepository() throws Exception {
        repositoryHomeDir = new File("repository");
        if (repositoryHomeDir.exists()) {
            Files.deleteRecursively((File)repositoryHomeDir);
        }
        String string = repositoryHomeDir.getAbsolutePath();
        JackrabbitRepositoryFactoryBean jackrabbitRepositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        jackrabbitRepositoryFactoryBean.setConfiguration((Resource)new ClassPathResource("jackrabbit-repository.xml"));
        jackrabbitRepositoryFactoryBean.setHomeDir((Resource)new FileSystemResource(string));
        jackrabbitRepositoryFactoryBean.setAutoInitialize(true);
        jackrabbitRepositoryFactoryBean.afterPropertiesSet();
        jackrabbitRepositoryFactoryBean.destroy();
    }

    @AfterClass
    public static void shutdown() {
        EventBus.publish((Event)new ShutdownEvent());
    }

    @Test
    public void testCliScripts() throws Exception {
        TemporaryDirectoryHolder.init(this.temporaryFolder.getRoot());
        logger.info("Executing script file " + this.scriptFile.getName());
        try {
            this.interpreter.evaluate((Reader)new FileReader(this.scriptFile));
        }
        catch (Exception exception) {
            logger.error("Exception while executing script " + this.scriptFile, (Throwable)exception);
            throw new Exception("Errors found during executing " + this.scriptFile.getName(), exception);
        }
        finally {
            TemporaryDirectoryHolder.destroy();
        }
    }

    @Before
    public void setupInterpreterAndCheckCleanRepository() throws IOException, ScriptException {
        this.interpreter = cli.getNewInterpreter();
        this.checkClean();
        this.scanForFileInParentDirectoriesAndExecute(SETUP_FILE, this.scriptFile.getParentFile());
    }

    private void scanForFileInParentDirectoriesAndExecute(String string, File file) throws ScriptException, FileNotFoundException {
        File file2 = new File(file, string);
        logger.info(file + ": " + file2);
        String string2 = BASE_TEST_DIR.substring(BASE_TEST_DIR.lastIndexOf(47) + 1);
        while (!file2.exists()) {
            logger.info(file.getAbsolutePath());
            if (file.getAbsolutePath().endsWith(string2)) break;
            file = file.getParentFile();
            file2 = new File(file, SETUP_FILE);
            logger.info(file + ": " + file2);
        }
        if (file2.exists()) {
            this.interpreter.evaluate((Reader)new FileReader(file2));
        }
    }

    private void checkClean() throws ScriptException, IOException {
        this.interpreter.evaluate((Reader)new InputStreamReader(new ClassPathResource("checkClean.py").getInputStream()));
    }

    @After
    public void tearDown() throws ScriptException, IOException {
        this.scanForFileInParentDirectoriesAndExecute(TEARDOWN_FILE, this.scriptFile.getParentFile());
    }

    static {
        testsToRunRegExpPattern = System.getProperty("DeployitIntegrationTest.testsToRunRegExpPattern", ".*\\.py");
        testsToRunPattern = Pattern.compile(testsToRunRegExpPattern);
        logger = LoggerFactory.getLogger(DeployitIntegrationTest.class);
    }
}

