/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.integration.test;

import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.integration.test.NiceParameterizedNames;
import com.xebialabs.deployit.integration.test.support.TemporaryDirectoryHolder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

@RunWith(value=NiceParameterizedNames.class)
public class DeployitIntegrationTest {
    private static final String SETUP_FILE = "setUp.py";
    private static final String TEARDOWN_FILE = "tearDown.py";
    private static final String BASE_TEST_DIR = "src/test/jython";
    private static String testsToRunRegExpPattern = System.getProperty("DeployitIntegrationTest.testsToRunRegExpPattern", ".*\\.py");
    private static Pattern testsToRunPattern = Pattern.compile(testsToRunRegExpPattern);
    private static Cli cli;
    private static String skipUntil;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Interpreter interpreter;
    private File scriptFile;
    private static final Logger logger;

    public DeployitIntegrationTest(File scriptFileToRun) {
        this.scriptFile = scriptFileToRun;
    }

    @Parameterized.Parameters
    public static List<Object[]> scriptsToRun() {
        String baseDir = System.getProperty("jythonTestBaseDir", BASE_TEST_DIR);
        logger.info("Running all tests in {}", (Object)baseDir);
        ArrayList<Object[]> targets = new ArrayList<Object[]>();
        DeployitIntegrationTest.scriptDir(new File(baseDir), targets);
        return targets;
    }

    private static void scriptDir(File testsDir, List<Object[]> targets) {
        if (testsDir.exists()) {
            File[] scriptFiles;
            for (File eachFile : scriptFiles = testsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isDirectory = new File(dir, name).isDirectory();
                    boolean testFrameworkFile = DeployitIntegrationTest.SETUP_FILE.equals(name) || DeployitIntegrationTest.TEARDOWN_FILE.equals(name);
                    boolean correctExtension = DeployitIntegrationTest.checkExtension(name, ".py") || DeployitIntegrationTest.checkExtension(name, ".cli");
                    return isDirectory || correctExtension && !testFrameworkFile;
                }
            })) {
                if (eachFile.isDirectory()) {
                    DeployitIntegrationTest.scriptDir(eachFile, targets);
                    continue;
                }
                DeployitIntegrationTest.addTarget(targets, eachFile);
            }
        }
    }

    private static boolean checkExtension(String name, String suffix) {
        return name.endsWith(suffix) || name.endsWith(suffix + "ignore");
    }

    private static void addTarget(List<Object[]> targets, File eachFile) {
        if (testsToRunPattern.matcher(eachFile.getName()).matches()) {
            logger.info("Adding testcase for {}", (Object)eachFile);
            targets.add(new Object[]{eachFile, !eachFile.getName().endsWith("ignore")});
        } else {
            logger.info("Ignoring testcase for {}", (Object)eachFile);
        }
    }

    @BeforeClass
    public static void init() throws Exception {
        CliOptions options = new CliOptions();
        options.setHost("localhost");
        options.setPort(9696);
        options.setExposeProxies(true);
        options.setUsername("admin");
        options.setPassword("admin");
        cli = new Cli(options);
    }

    private static void cleanupTaskBackup() {
        File recoveryDir = new File("work");
        if (recoveryDir.exists()) {
            for (File file : recoveryDir.listFiles()) {
                if (!file.getName().endsWith(".task")) continue;
                file.delete();
            }
        }
    }

    @Test
    public void testCliScripts() throws Exception {
        if (this.skipCurrentTest()) {
            return;
        }
        skipUntil = null;
        TemporaryDirectoryHolder.init(this.temporaryFolder.getRoot());
        try {
            this.interpreter.evaluate((Reader)new FileReader(this.scriptFile));
        }
        catch (Exception e) {
            logger.error("Exception while executing script " + this.scriptFile, (Throwable)e);
            throw new Exception("Errors found during executing " + this.scriptFile.getName(), e);
        }
        finally {
            TemporaryDirectoryHolder.destroy();
        }
    }

    private boolean skipCurrentTest() {
        return skipUntil != null && !skipUntil.equals(this.scriptFile.getName());
    }

    @Before
    public void setupInterpreterAndCheckCleanRepository() throws IOException, ScriptException {
        if (this.skipCurrentTest()) {
            logger.info("Skipping {}", (Object)this.scriptFile.getName());
            return;
        }
        logger.info("Executing {}", (Object)this.scriptFile.getName());
        this.interpreter = cli.getNewInterpreter();
        this.checkClean();
        DeployitIntegrationTest.cleanupTaskBackup();
        this.scanForFileInParentDirectoriesAndExecute(SETUP_FILE, this.scriptFile.getParentFile());
    }

    private void scanForFileInParentDirectoriesAndExecute(String fileNameToScanUpFor, File parentDir) throws ScriptException, FileNotFoundException {
        File setUp = new File(parentDir, fileNameToScanUpFor);
        logger.info(parentDir + ": " + setUp);
        String lastPartOfBaseTestDir = BASE_TEST_DIR.substring(BASE_TEST_DIR.lastIndexOf(47) + 1);
        while (!setUp.exists() && !parentDir.getAbsolutePath().endsWith(lastPartOfBaseTestDir)) {
            parentDir = parentDir.getParentFile();
            setUp = new File(parentDir, SETUP_FILE);
            logger.info(parentDir + ": " + setUp);
        }
        if (setUp.exists()) {
            this.interpreter.evaluate((Reader)new FileReader(setUp));
        }
    }

    private void checkClean() throws ScriptException, IOException {
        this.interpreter.evaluate((Reader)new InputStreamReader(new ClassPathResource("checkClean.py").getInputStream()));
    }

    @After
    public void tearDown() throws ScriptException, IOException {
        if (this.skipCurrentTest()) {
            return;
        }
        this.scanForFileInParentDirectoriesAndExecute(TEARDOWN_FILE, this.scriptFile.getParentFile());
    }

    static {
        skipUntil = null;
        logger = LoggerFactory.getLogger(DeployitIntegrationTest.class);
    }
}

