package com.xebialabs.deployit.plugin;

import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class TestServiceHolder {

    private static final AtomicReference<ImporterService> importerService = new AtomicReference<ImporterService>();
    private static final AtomicReference<UserService> userService = new AtomicReference<UserService>();
    private static final AtomicReference<Engine> engine = new AtomicReference<Engine>();
    private static final AtomicReference<JcrTaskArchive> taskArchive = new AtomicReference<JcrTaskArchive>();
    private static final AtomicReference<WorkDirFactory> workDirFactory = new AtomicReference<WorkDirFactory>();
    private static final AtomicReference<RoleService> roleService = new AtomicReference<RoleService>(); 
    private static final AtomicReference<PermissionEditor> permissionEditor = new AtomicReference<PermissionEditor>();

    @Autowired
    public TestServiceHolder(ImporterService importerService, UserService userService, Engine engine, JcrTaskArchive taskArchive, WorkDirFactory workDirFactory, RoleService roleService, PermissionEditor permissionEditor) {
        TestServiceHolder.importerService.set(importerService);
        TestServiceHolder.userService.set(userService);
        TestServiceHolder.engine.set(engine);
        TestServiceHolder.taskArchive.set(taskArchive);
        TestServiceHolder.workDirFactory.set(workDirFactory);
        TestServiceHolder.roleService.set(roleService);
        TestServiceHolder.permissionEditor.set(permissionEditor);
    }

    public static ImporterService getImporterService() {
        return TestServiceHolder.importerService.get();
    }

    public static UserService getUserService() {
        return TestServiceHolder.userService.get();
    }

    public static Engine getExecutionEngine() {
        return TestServiceHolder.engine.get();
    }

    public static JcrTaskArchive getTaskArchive() {
        return TestServiceHolder.taskArchive.get();
    }

    public static WorkDirFactory getWorkDirFactory() {
        return TestServiceHolder.workDirFactory.get();
    }
    
    public static RoleService getRoleService() {
        return TestServiceHolder.roleService.get();
    }
    
    public static PermissionEditor getPermissionEditor() {
        return TestServiceHolder.permissionEditor.get();
    }
}
