package com.xebialabs.deployit.rest.test.api.datasets

import com.xebialabs.deployit.rest.test.api.DataSet
import java.util.UUID
import org.joda.time.DateTime
import scala.collection.immutable.List
import scala.util.Random
import com.xebialabs.deployit.plugin.api.udm._

object DemoSet extends DataSet {

  val random = new Random()
  
  def name() = "demo"

  def generateSet() {
    // Generate data to show off the report dashboard
    generateCurrentMonthData
    generateSixMonthData
  }

  object TaskState extends Enumeration {
    type TaskState = Value
    val SUCCESSFUL, FAILED, ABORTED = Value
  }

  import TaskState._

  private def generateCurrentMonthData = {
    // Strictly, we don't know whether this will all be in the current month, but at least a couple of them will be ;-)
    createCurrentTask("PetPortal", "1.0", "Ops/Acc/ACC", days = 3, durationInMinutes = random.nextInt(3), SUCCESSFUL)
    createCurrentTask("StockTrader", "5.0", "Dev/DEV-DOTNET", days = 3, durationInMinutes = random.nextInt(9), ABORTED)
    createCurrentTask("StockTrader", "5.0", "Ops/Prod/PROD", days = 3, durationInMinutes = random.nextInt(11), SUCCESSFUL)
    createCurrentTask("NerdDinner", "2.0", "Dev/DEV-DOTNET", days = 3, durationInMinutes = random.nextInt(9), SUCCESSFUL)
    createCurrentTask("PetPortal", "2.0", "Dev/DEV", days = 2, durationInMinutes = random.nextInt(4), SUCCESSFUL)
    createCurrentTask("StockTrader", "5.0", "Dev/DEV-DOTNET", days = 2, durationInMinutes = random.nextInt(11), SUCCESSFUL)
    createCurrentTask("NerdDinner", "2.0", "Ops/Acc/ACC", days = 2, durationInMinutes = random.nextInt(11), FAILED)
    createCurrentTask("NerdDinner", "2.0", "Ops/Acc/ACC", days = 2, durationInMinutes = random.nextInt(13), SUCCESSFUL)
    createCurrentTask("PetPortal", "1.0", "Ops/Prod/PROD", days = 1, durationInMinutes = random.nextInt(6), SUCCESSFUL)
    createCurrentTask("StockTrader", "5.0", "Dev/DEV-DOTNET", days = 1, durationInMinutes = random.nextInt(11), SUCCESSFUL)
    createCurrentTask("NerdDinner", "2.0", "Ops/Acc/ACC", days = 1, durationInMinutes = random.nextInt(11), FAILED)
    createCurrentTask("PetClinic-ear", "2.0", "Dev/TEST", days = 1, durationInMinutes = random.nextInt(4), ABORTED)
  }
  
  private def randomState(s1: TaskState, s2: TaskState): TaskState = {
    if (random.nextBoolean()) s1 else s2
  }
  
  private def generateSixMonthData = {
    // This data is meant to show a progression of more and more successful deployments over a 6 month period
    for (i <- 1 to 6) {
        for (j <- 0 to (35 - (i*4))) {
            createTask("PetClinic-ear", "2.0", "Dev/TEST", month = i, durationInMinutes = random.nextInt(15), randomState(SUCCESSFUL, FAILED))
            createTask("PetPortal", "1.0", "Ops/Acc/ACC", month = i, durationInMinutes = random.nextInt(15), randomState(SUCCESSFUL, ABORTED))
            createTask("PetClinic-war", "1.0", "Dev/DEV", month = i, durationInMinutes = random.nextInt(8), randomState(SUCCESSFUL, FAILED))
            createTask("NerdDinner", "2.0", "Dev/DEV-DOTNET", month = i, durationInMinutes = random.nextInt(11), SUCCESSFUL)
            createTask("StockTrader", "5.0", "Dev/DEV-DOTNET", month = i, durationInMinutes = random.nextInt(5), SUCCESSFUL)
        }
    }
  }
  
    def createTask(appName: String, version: String, envName: String, month: Int, durationInMinutes: Int, state: TaskState) {
      val startDate = new DateTime().minusMonths(month)
      val completionDate = startDate.plusMinutes(durationInMinutes)

      task { t =>
        (state match {
          case SUCCESSFUL => t.success
          case FAILED => t.successWithFails
          case ABORTED => t.failed
        }).forApp(appName).forVersion(version).forEnv(envName).startedAt(startDate).completedAt(completionDate).withId(UUID.randomUUID().toString())

      }
    }
    
    def createCurrentTask(appName: String, version: String, envName: String, days: Int, durationInMinutes: Int, state: TaskState) {
      val startDate = new DateTime().minusDays(days)
      val completionDate = startDate.plusMinutes(durationInMinutes)

      task { t =>
        (state match {
          case SUCCESSFUL => t.success
          case FAILED => t.successWithFails
          case ABORTED => t.failed
        }).forApp(appName).forVersion(version).forEnv(envName).startedAt(startDate).completedAt(completionDate).withId(UUID.randomUUID().toString())

      }
    }

}