package com.xebialabs.deployit.cli.api;

import javax.ws.rs.core.Response;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.core.api.*;
import com.xebialabs.deployit.core.rest.DryRunResource;
import com.xebialabs.deployit.core.rest.PreviewResource;
import com.xebialabs.deployit.engine.api.*;
import com.xebialabs.xlplatform.support.api.SupportProxy;

/**
 */
public class ProxiesInstance {

    private final DeployitCommunicator communicator;

    public ProxiesInstance(BooterConfig c) {
        communicator = RemoteBooter.getCommunicator(c);
        registerProxies(c.getUrl());
    }

    private void registerProxies(String url) {
        communicator.getProxies().registerProxy(url, InternalReportProxy.class,
                InternalReportProxyDefaults.class, InternalReportProxyDefaults.getLookup());
        communicator.getProxies().registerProxy(url, InternalSecurityProxy.class);
        communicator.getProxies().registerProxy(url, InternalComparisonProxy.class);
        communicator.getProxies().registerProxy(url, PackageExportProxy.class);
        communicator.getProxies().registerProxy(url, InternalHistoryProxy.class);
        communicator.getProxies().registerProxy(url, BannerService.class);
        communicator.getProxies().registerProxy(url, WorkersService.class);
        communicator.getProxies().registerProxy(url, PlaceholderService.class);
        communicator.getProxies().registerProxy(url, SessionService.class);
        communicator.getProxies().registerProxy(url, DryRunResource.class);
        communicator.getProxies().registerProxy(url, PreviewResource.class);
        communicator.getProxies().registerProxy(url, SupportProxy.class);
    }

    private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
        return communicator.getProxies().getProxyInstance(proxyClass);
    }

    public BannerService getBanner() {
        return getRestEasyProxyInstance(BannerService.class);
    }

    public ControlService getControlTask() {
        return getRestEasyProxyInstance(ControlService.class);
    }

    public DeploymentService getDeployment() {
        return getRestEasyProxyInstance(DeploymentService.class);
    }

    public PackageService getImportablePackage() {
        return getRestEasyProxyInstance(PackageService.class);
    }

    public RepositoryService getRepository() {
        return getRestEasyProxyInstance(RepositoryService.class);
    }

    public InspectionService getDiscovery() {
        return getRestEasyProxyInstance(InspectionService.class);
    }

    public TaskService getTaskRegistry() {
        return getRestEasyProxyInstance(TaskService.class);
    }

    public TaskBlockService getTaskBlockRegistry() {
        return getRestEasyProxyInstance(TaskBlockService.class);
    }

    public UserService getUser() {
        return getRestEasyProxyInstance(UserService.class);
    }

    public MetadataService getReferenceData() {
        return getRestEasyProxyInstance(MetadataService.class);
    }

    public ConfigurationService getConfiguration() {
        return getRestEasyProxyInstance(ConfigurationService.class);
    }

    public InternalReportProxy getReport() {
        return getRestEasyProxyInstance(InternalReportProxy.class);
    }

    public PermissionService getPermissions() {
        return getRestEasyProxyInstance(PermissionService.class);
    }

    public InternalSecurityProxy getInternalSecurity() {
        return getRestEasyProxyInstance(InternalSecurityProxy.class);
    }

    public SupportProxy getSupport() {
        return getRestEasyProxyInstance(SupportProxy.class);
    }

    public PackageExportProxy getExportProxy() {
        return getRestEasyProxyInstance(PackageExportProxy.class);
    }

    public ServerService getServer() {
        return getRestEasyProxyInstance(ServerService.class);
    }

    public InternalComparisonProxy getComparison() {
        return getRestEasyProxyInstance(InternalComparisonProxy.class);
    }

    public RoleService getRoleService() {
        return getRestEasyProxyInstance(RoleService.class);
    }

    public InternalHistoryProxy getHistoryService() {
        return getRestEasyProxyInstance(InternalHistoryProxy.class);
    }

    public WorkersService getWorkers() {
        return getRestEasyProxyInstance(WorkersService.class);
    }

    public PlaceholderService getPlaceholderService() {
        return getRestEasyProxyInstance(PlaceholderService.class);
    }

    public SessionService getSessionService() {
        return getRestEasyProxyInstance(SessionService.class);
    }

    public DryRunResource getDryRunResource() {
        return getRestEasyProxyInstance(DryRunResource.class);
    }

    public PreviewResource getPreviewResource() {
        return getRestEasyProxyInstance(PreviewResource.class);
    }

    public DeployitCommunicator getCommunicator() {
        return communicator;
    }
}
