package ai.digital.deploy.jmx

import com.typesafe.config.Config
import com.xebialabs.xlplatform.settings.{SecuritySettings, SettingsSupport}

class JMXSettings(val config: Config) extends SettingsSupport {
  import SettingsSupport._
  lazy val enabled: Boolean = valueWithDefault[Boolean]("deploy.jmx.enabled", false)
  lazy val hostname: String = value[String]("deploy.jmx.hostname")
  lazy val port: Int = value[Int]("deploy.jmx.port")
  lazy val ssl: SecuritySettings = new SecuritySettings(config.getConfig("deploy.jmx.ssl"))
}
