package com.xebialabs.deployit.client;

import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;

import java.util.List;

class RepositoryClient {
	private final DeployitProxies proxies;

	public RepositoryClient(final DeployitProxies proxies) {
		this.proxies = proxies;
	}

	public RepositoryObject read(final String id) {
		return new ResponseExtractor(proxies.getRepository().read(id)).getEntity();
	}

	public void delete(final String id) {
		new ResponseExtractor(proxies.getRepository().delete(id));
	}

	public List<ConfigurationItemId> search(String type, String parent) {
		ConfigurationItemIds ids = new ResponseExtractor(proxies.getQuery().list(type, Boolean.FALSE, 0, -1, null, parent, null)).getEntity();
		return ids.getConfigurationItemIds();
	}


}
