/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    protected String type;
    protected String id;
    protected boolean addedToEnvironment = true;
    protected final Map<String, Object> properties = Maps.newHashMap();

    public String getType() {
        return this.type;
    }

    public String getId() {
        if (this.id == null) {
            throw new IllegalStateException("id cannot be null");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addParameter(String name, Object value) {
        if ("addedToEnvironment".equals(name)) {
            this.addedToEnvironment = Boolean.parseBoolean(value.toString());
            return;
        }
        if ("type".equals(name)) {
            this.setType(value.toString());
            return;
        }
        if ("id".equals(name)) {
            this.id = value.toString();
            return;
        }
        this.properties.put(name, value);
    }

    public boolean isAddedToEnvironment() {
        return this.addedToEnvironment;
    }

    public void setAddedToEnvironment(boolean addedToEnvironment) {
        this.addedToEnvironment = addedToEnvironment;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        Set<Map.Entry<String, Object>> entries = this.getProperties().entrySet();
        String properties = "{";
        boolean first = false;
        for (Map.Entry<String, Object> e : entries) {
            properties = properties + (first ? "," : "") + "\"" + e.getKey() + "\":\"" + e.getValue() + "\"";
            first = true;
        }
        properties = properties + "}";
        return String.format("repository.create(\"%s\",factory.configurationItem(\"%s\", %s))", this.getId(), this.getType(), properties);
    }
}

