/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.client;

import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import java.util.Arrays;
import java.util.HashSet;

public class DeployitClient {
    private DeploymentListener listener;

    public DeployitClient(DeploymentListener listener) {
        this.listener = listener;
    }

    public TaskState retrieveTaskInfo(String taskId) {
        return Proxies.getTaskService().getTask(taskId);
    }

    public void stopTask(String taskId) {
        Proxies.getTaskService().stop(taskId);
    }

    public void startTask(String taskId) {
        Proxies.getTaskService().start(taskId);
    }

    public void startTaskAndWait(String taskId) {
        this.startTask(taskId);
        boolean done = false;
        while (!done) {
            TaskState ti = this.retrieveTaskInfo(taskId);
            TaskExecutionState state = ti.getState();
            this.listener.debug("Task state: " + state.toString());
            done = new HashSet<TaskExecutionState>(){
                {
                    this.add(TaskExecutionState.DONE);
                    this.add(TaskExecutionState.EXECUTED);
                    this.add(TaskExecutionState.STOPPED);
                    this.add(TaskExecutionState.CANCELLED);
                }
            }.contains(state);
            try {
                Thread.sleep(1000L);
                this.listener.debug("Waiting for task to be done...");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void abortTask(String taskId) {
        Proxies.getTaskService().abort(taskId);
    }

    public void cancelTask(String taskId) {
        Proxies.getTaskService().cancel(taskId);
    }

    public void skipSteps(String taskId, Integer[] stepIds) {
        Proxies.getTaskService().skip(taskId, Arrays.asList(stepIds));
    }
}

