package com.xebialabs.deployit.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import static java.lang.String.format;

public class ConnectionOptions {

    static final int DEFAULT_DEPLOYIT_SERVER_PORT = 4516;
    static final int DEFAULT_DEPLOYIT_SERVER_SECURE_PORT = 4517;
    static final String DEFAULT_DEPLOYIT_SERVER_HOST = "127.0.0.1";
    static final String DEFAULT_USERNAME = "admin";
    static final String DEFAULT_PASSWORD = "admin";


    private String host = DEFAULT_DEPLOYIT_SERVER_HOST;
    private int port = -1;
    private String proxyHost;
    private int proxyPort = -1;
    private String username = DEFAULT_USERNAME;
    private String password = DEFAULT_PASSWORD;
    private String context = "deployit";
    private boolean secured = false;

    public ConnectionOptions() {

    }

    public ConnectionOptions(String host, int port, String username, String password, String context, boolean secured) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.context = context;
        this.secured = secured;
    }

    public ConnectionOptions(String deployitServerUrl, String username, String password) {
        try {
            URL url = new URL(deployitServerUrl);
            setHost(url.getHost());
            setPort(url.getPort());
            setSecured("https".equalsIgnoreCase(url.getProtocol()));
            if (url.getPath().length() > 0)
                setContext(url.getPath().substring(1));

        } catch (MalformedURLException e) {
            throw new RuntimeException("MalformedURLException", e);
        }
        this.username = username;
        this.password = password;
    }

    public ConnectionOptions(String deployitServerUrl, String deployitClientProxyUrl, String username, String password) {
        this(deployitServerUrl, username, password);
        if (deployitClientProxyUrl != null) {
            URI proxyUri = URI.create(deployitClientProxyUrl);
            proxyHost = proxyUri.getHost();
            proxyPort = proxyUri.getPort();
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return port == -1 ? (secured ? DEFAULT_DEPLOYIT_SERVER_SECURE_PORT : DEFAULT_DEPLOYIT_SERVER_PORT) : port;
    }
    
    public boolean isProxiedConnection() {
        return proxyPort != -1 && proxyHost != null;
    }

    public String getProxyHost() {
        return proxyHost;
    }
    
    public int getProxyPort() {
        return proxyPort;
    }

    public String getUsername() {
        return username == null ? DEFAULT_USERNAME : username;
    }

    public void setUsername(final String username) {
        this.username = username;
    }

    public String getPassword() {
        return password == null ? DEFAULT_PASSWORD : password;
    }

    public void setPassword(final String password) {
        this.password = password;
    }

    public boolean isSecured() {
        return secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public String getUrl() {
        return format("http%s://%s:%d/%s", secured ? "s" : "", host, getPort(), getContext());
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

}