package com.xebialabs.deployit.client.logger;


import com.xebialabs.deployit.client.DeploymentListener;

public abstract class AbstractDeploymentListener implements DeploymentListener {

	private DeploymentListener actionListener;

	@Override
	public void setActionListener(DeploymentListener listener) {
		this.actionListener = listener;
	}

	abstract protected void handleDebug(String message);

	abstract protected void handleInfo(String message);

	abstract protected void handleTrace(String message);

	abstract protected void handleError(String message);

	@Override
	public void debug(String message) {
		if (actionListener == null || actionListener.equals(this)) {
			handleDebug(message);
		} else {
			actionListener.debug(message);
		}
	}

	@Override
	public void info(String message) {
		if (actionListener == null || actionListener.equals(this)) {
			handleInfo(message);
		} else {
			actionListener.info(message);
		}
	}

	@Override
	public void trace(String message) {
		if (actionListener == null || actionListener.equals(this)) {
			handleTrace(message);
		} else {
			actionListener.trace(message);
		}
	}

	@Override
	public void error(String message) {
		if (actionListener == null || actionListener.equals(this)) {
			handleError(message);
		} else {
			actionListener.error(message);
		}
	}

}
