/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.boot.PluginBooter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiReferenceHtmlGenerator {
    private List<String> prefixes;
    private PrintWriter writer;
    private static final Predicate<Descriptor> DEPLOYABLE_PREDICATE;
    private static final Predicate<Descriptor> VIRTUAL_DEPLOYABLE_PREDICATE;
    private static final Predicate<Descriptor> DEPLOYED_PREDICATE;
    private static final Predicate<Descriptor> VIRTUAL_DEPLOYED_PREDICATE;
    private static final Predicate<Descriptor> TOPOLOGY_PREDICATE;
    private static final Predicate<Descriptor> VIRTUAL_TOPOLOGY_PREDICATE;
    private static final Predicate<PropertyDescriptor> HIDDEN_PROPERTY_PREDICATE;
    private static final Predicate<PropertyDescriptor> PUBLIC_PROPERTY_PREDICATE;
    private static final Logger logger;

    public CiReferenceHtmlGenerator(List<String> list, PrintWriter printWriter) {
        this.prefixes = list;
        this.writer = printWriter;
    }

    public void generate() {
        logger.info("Generating documentation for " + (!this.prefixes.isEmpty() ? "CIs with prefix '" + this.prefixes + "'" : "all CIs"));
        List<Descriptor> list = this.findDescriptorsToGenerateReferenceDocFor(this.prefixes);
        logger.info("Found " + list.size() + " CI descriptors to generate documentation for.");
        this.writer.println("<div style='width:100%; position:relative'>");
        this.generateCiTableOfContentForAllCategories(list);
        this.generateCiDetails(list);
        this.writer.println("</div>");
    }

    private void generateCiTableOfContentForAllCategories(Collection<Descriptor> collection) {
        this.writer.printf("<h1 class='ci-toc-category'>CI Reference</h1>", new Object[0]);
        this.writer.printf("<h2>Configuration Item Overview</h2>", new Object[0]);
        this.generateCiTableOfContentForCategory(collection, "Deployable Configuration Items", DEPLOYABLE_PREDICATE);
        this.generateCiTableOfContentForCategory(collection, "Deployed Configuration Items", DEPLOYED_PREDICATE);
        this.generateCiTableOfContentForCategory(collection, "Topology Configuration Items", TOPOLOGY_PREDICATE);
        this.generateCiTableOfContentForCategory(collection, "Virtual Deployable Configuration Items", VIRTUAL_DEPLOYABLE_PREDICATE);
        this.generateCiTableOfContentForCategory(collection, "Virtual Deployed Configuration Items", VIRTUAL_DEPLOYED_PREDICATE);
        this.generateCiTableOfContentForCategory(collection, "Virtual Topology Configuration Items", VIRTUAL_TOPOLOGY_PREDICATE);
    }

    private void generateCiDetails(Collection<Descriptor> collection) {
        this.writer.printf("<h2 class='ci-details-title'>Configuration Item Details</h2>", new Object[0]);
        for (Descriptor descriptor : collection) {
            this.writer.printf("<a name='%s'></a><h3 class='ci-detail-title'>%s</h3>", descriptor.getType(), descriptor.getType());
            if (!descriptor.getSuperClasses().isEmpty()) {
                this.writer.print("<div><table class='ci-relations-table'>");
                if (!descriptor.getSuperClasses().isEmpty()) {
                    this.generateTypeRow(descriptor.getSuperClasses(), "Hierarchy", "<span> >> </span>");
                }
                if (!descriptor.getInterfaces().isEmpty()) {
                    this.generateTypeRow(descriptor.getInterfaces(), "Interfaces", "<span>, </span>");
                }
                this.writer.print("</table></div>");
            }
            this.writer.printf("<p class='ci-description'>%s</p>\n", descriptor.getDescription());
            Collection<PropertyDescriptor> collection2 = this.sortProperties(descriptor.getPropertyDescriptors());
            this.generateCiPropertiesTable(collection2, "Public Properties", PUBLIC_PROPERTY_PREDICATE);
            this.generateCiPropertiesTable(collection2, "Hidden Properties", HIDDEN_PROPERTY_PREDICATE);
            Collection<MethodDescriptor> collection3 = this.sortMethodDescriptors(descriptor.getControlTasks());
            this.generateCiControlTaskTable(collection3, "Control Tasks");
            this.writer.println("<hr class='ci-details-separator'/>");
        }
    }

    private void generateTypeRow(Collection<Type> collection, String string, String string2) {
        this.writer.printf("<tr><th>%s</th><td>", string);
        int n = 0;
        for (Type type : collection) {
            this.writeTypeAnchor(type);
            if (++n >= collection.size()) continue;
            this.writer.print(string2);
        }
        this.writer.print("</td></tr>");
    }

    private void writeTypeAnchor(Type type) {
        if (this.isTypePartOfReferencedDoc(type)) {
            this.writer.printf("<a href='#%s'>%s</a>", type, type);
        } else {
            this.writer.printf("<span>%s</span>", type);
        }
    }

    private void generateCiPropertiesTable(Collection<PropertyDescriptor> collection, String string, Predicate<PropertyDescriptor> predicate) {
        Collection collection2 = Collections2.filter(collection, predicate);
        if (collection2.isEmpty()) {
            return;
        }
        this.writer.printf("<table class='ci-properties nobreak'  cellspacing='0' cellpadding='3'><tr class='odd ci-prop-header'><th>%s</th></tr>", string);
        int n = 0;
        for (PropertyDescriptor propertyDescriptor : collection2) {
            String string2 = n % 2 == 0 ? "even" : "odd";
            String string3 = "";
            if (propertyDescriptor.isRequired()) {
                string3 = "<span class='required'>&nbsp;</span>";
            }
            String string4 = "";
            if (propertyDescriptor.isAsContainment()) {
                string4 = string4 + "<img title='Containment relationship' class='containerImg' src='image/container.png'/>";
            }
            if (propertyDescriptor.isInspectionProperty()) {
                string4 = string4 + "<img title='Inspection property.' class='inspectImg' src='image/inspect.png'/>";
            }
            String string5 = propertyDescriptor.getKind().toString();
            if (propertyDescriptor.getKind() == PropertyKind.ENUM) {
                string5 = string5 + " " + Arrays.toString(propertyDescriptor.getEnumValues().toArray());
            }
            if (propertyDescriptor.getKind() == PropertyKind.CI || propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
                string5 = string5 + "&lt;" + propertyDescriptor.getReferencedType() + "&gt;";
            }
            String string6 = "";
            if (propertyDescriptor.getDefaultValue() != null) {
                string6 = "&nbsp;=&nbsp;<span class='ci-property-default'>" + propertyDescriptor.getDefaultValue() + "</span>";
            }
            this.writer.printf("<tr class='%s'><td>%s<a name='%s_%s'></a><span class='ci-property-name'>%s</span>%s&nbsp;:&nbsp;<span class='ci-property-kind'>%s</span>%s<p class='ci-property-desc'>%s</p></td>\n", string2, string4, propertyDescriptor.getDeclaringDescriptor().getType(), propertyDescriptor.getName(), propertyDescriptor.getName(), string3, string5, string6, propertyDescriptor.getDescription());
            ++n;
        }
        this.writer.println("</table>");
    }

    private void generateCiControlTaskTable(Collection<MethodDescriptor> collection, String string) {
        if (collection.isEmpty()) {
            return;
        }
        this.writer.printf("<table class='ci-properties nobreak'  cellspacing='0' cellpadding='3'><tr class='odd ci-prop-header'><th>%s</th></tr>", string);
        int n = 0;
        for (MethodDescriptor methodDescriptor : collection) {
            String string2 = n % 2 == 0 ? "even" : "odd";
            String string3 = "";
            this.writer.printf("<tr class='%s'><td>%s<a name='%s_%s'></a><span class='ci-property-name'>%s</span><p class='ci-property-desc'>%s</p></td>\n", string2, string3, methodDescriptor.getDeclaringDescriptor().getType(), methodDescriptor.getName(), methodDescriptor.getName(), methodDescriptor.getDescription());
            ++n;
        }
        this.writer.println("</table>");
    }

    private void generateCiTableOfContentForCategory(Collection<Descriptor> collection, String string, Predicate<Descriptor> predicate) {
        Collection collection2 = Collections2.filter(collection, predicate);
        if (!collection2.isEmpty()) {
            this.writer.printf("<h3 class='ci-toc-category'>%s</h3>", string);
            this.generateCiTableOfContent(collection2, this.writer);
        }
    }

    private void generateCiTableOfContent(Collection<Descriptor> collection, PrintWriter printWriter) {
        printWriter.println("<table class='ci-toc nobreak'  cellspacing='0' cellpadding='3'><tr class='odd ci-toc-header'><th>CI</th><th>Description</th></tr>");
        int n = 0;
        for (Descriptor descriptor : collection) {
            String string = n % 2 == 0 ? "even" : "odd";
            printWriter.printf("<tr class='%s'><td><a href='#%s'>%s</a></td><td>%s</td>\n", string, descriptor.getType(), descriptor.getType(), this.extractFirstSentence(descriptor.getDescription()));
            ++n;
        }
        printWriter.println("</table>");
    }

    private String extractFirstSentence(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(".") > -1) {
            return string.substring(0, string.indexOf("."));
        }
        return string;
    }

    private List<Descriptor> findDescriptorsToGenerateReferenceDocFor(List<String> list) {
        Collection collection = Collections2.filter((Collection)DescriptorRegistry.getDescriptors(), (Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return CiReferenceHtmlGenerator.this.isTypePartOfReferencedDoc(descriptor.getType());
            }
        });
        ArrayList arrayList = Lists.newArrayList((Iterable)collection);
        Collections.sort(arrayList, new Comparator<Descriptor>(){

            @Override
            public int compare(Descriptor descriptor, Descriptor descriptor2) {
                return descriptor.getType().toString().compareTo(descriptor2.getType().toString());
            }
        });
        return arrayList;
    }

    private boolean isTypePartOfReferencedDoc(Type type) {
        return this.prefixes.isEmpty() || this.prefixes.contains(type.getPrefix());
    }

    private Collection<PropertyDescriptor> sortProperties(Collection<PropertyDescriptor> collection) {
        ArrayList arrayList = Lists.newArrayList(collection);
        Collections.sort(arrayList, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
                int n;
                int n2 = propertyDescriptor.isRequired() == propertyDescriptor2.isRequired() ? 0 : (n = propertyDescriptor.isRequired() ? -1 : 1);
                if (n == 0) {
                    n = propertyDescriptor.getName().compareTo(propertyDescriptor2.getName());
                }
                return n;
            }
        });
        return arrayList;
    }

    private Collection<MethodDescriptor> sortMethodDescriptors(Collection<MethodDescriptor> collection) {
        ArrayList arrayList = Lists.newArrayList(collection);
        Collections.sort(arrayList, new Comparator<MethodDescriptor>(){

            @Override
            public int compare(MethodDescriptor methodDescriptor, MethodDescriptor methodDescriptor2) {
                return methodDescriptor.getName().compareTo(methodDescriptor2.getName());
            }
        });
        return arrayList;
    }

    static {
        PluginBooter.bootWithoutGlobalContext();
        DEPLOYABLE_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return !descriptor.isVirtual() && descriptor.isAssignableTo(Deployable.class);
            }
        };
        VIRTUAL_DEPLOYABLE_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return descriptor.isVirtual() && descriptor.isAssignableTo(Deployable.class);
            }
        };
        DEPLOYED_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return !descriptor.isVirtual() && descriptor.isAssignableTo(Deployed.class);
            }
        };
        VIRTUAL_DEPLOYED_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return descriptor.isVirtual() && descriptor.isAssignableTo(Deployed.class);
            }
        };
        TOPOLOGY_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return !descriptor.isVirtual() && !descriptor.isAssignableTo(Deployable.class) && !descriptor.isAssignableTo(Deployed.class);
            }
        };
        VIRTUAL_TOPOLOGY_PREDICATE = new Predicate<Descriptor>(){

            public boolean apply(Descriptor descriptor) {
                return descriptor.isVirtual() && !descriptor.isAssignableTo(Deployable.class) && !descriptor.isAssignableTo(Deployed.class);
            }
        };
        HIDDEN_PROPERTY_PREDICATE = new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                return propertyDescriptor.isHidden();
            }
        };
        PUBLIC_PROPERTY_PREDICATE = new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                return !propertyDescriptor.isHidden();
            }
        };
        logger = LoggerFactory.getLogger(CiReferenceHtmlGenerator.class);
    }
}

