/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.distribution

import com.xebialabs.deployit.engine.api.dto.Worker

/**
  * Repository for storing security information about task execution workers that connect to XLD remotely and need access to the resources exposed by the master.
  * Workers subscribe to the master and send their (generated) public key. This is used to verify the RSA Signature that is added to every HTTP Request
  * from worker to master in case when workers are calling the REST API exposed by the XLD master
  */
trait TaskExecutionWorkerRepository {
  /**
    * Store worker information in the database.
    */
  def storeWorker(worker: Worker): Unit

  /**
    * Returns a worker by Id.
    */
  def getWorker(id: Integer): Option[Worker]

  /**
    * Returns a worker with specified worker address
    */
  def getWorkerByAddress(address: String): Option[Worker]

  /**
    * Removes the worker from the repository.
    */
  def removeWorker(id: Integer): Unit

  /**
    * Removes the worker from the repository.
    */
  def removeWorker(address: String): Unit

  /**
    * Return a tuple of all available workers, together with amount of
    * deployment tasks and control tasks running on that worker.
    */
  def listWorkers: List[(Worker, Integer, Integer)]

  /**
    * Removes the tasks related to the worker from the repository.
    */
  def removeTasks(id: Integer): Unit
}
