/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.io.Serializable;

/**
 * A reference to a {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}, containing the {@code id} and {@code type}.
 */
@PublicApiRef
public class ConfigurationItemId implements Serializable {

    private String id;
    private Type type;

    public ConfigurationItemId() {
    }

    /**
     * @param id The id of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     * @param type The type of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public ConfigurationItemId(String id, Type type) {
        this.id = id;
        this.type = type;
    }

    /**
     * @return The id of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public String getId() {
        return id;
    }

    /**
     * @param id The id of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return The type of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public Type getType() {
        return type;
    }

    /**
     * @param type The type of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return String.format("%s [%s]", id, type);
    }
}
