/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto

import scala.language.implicitConversions

object ImplicitConversions {
  implicit def listOfOrderingToListOfTuples(iterable: List[Ordering]): List[(String, Boolean)] =
    iterable.map(_.toTuple)

  implicit def pagingToTuple(paging: Paging): (Int, Int) = paging.toTuple

  implicit def pagingOptionToTupleOption(paging: Option[Paging]): Option[(Int, Int)] =
    paging.map(pagingToTuple)
}
