/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * All possible values for the execution state of a block.
 */
@PublicApiRef
public enum BlockExecutionState {
    PENDING, EXECUTING, DONE, FAILING, FAILED, STOPPING, STOPPED, ABORTING, ABORTED;

    public boolean isFinished() {
        return this == DONE || this == FAILED || this == STOPPED || this == ABORTED;
    }

    public boolean isReadyForExecution() {
        return this == PENDING || this == FAILED || this == STOPPED || this == ABORTED; }

    public boolean isExecuting() {
        return this == EXECUTING || this == FAILING || this == STOPPING || this == ABORTING;
    }
}
