/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto

import java.util
import com.xebialabs.deployit.checks.Checks.checkArgument

class Ordering(ordering: String) {

  var field: String = ordering
  var direction: Direction.Value = Direction.ASC

  object Direction extends Enumeration {
    type Direction = Value
    val ASC, DESC, UNKNOWN = Value

    def withNameOpt(name: String): Value =
      values.find(_.toString.toLowerCase == name.toLowerCase()).getOrElse(UNKNOWN)
  }

  direction = Direction.withNameOpt(field.toUpperCase)

  if (ordering.indexOf(':') != -1) {
    def split = ordering.split(":")
    field = split(0)
    direction = Direction.withNameOpt(split(1))
  }

  def isAscending: Boolean = direction == Direction.ASC

  def validate(allowedSortFields: util.Set[String]): Unit = {
    if (field != null) {
      checkArgument(allowedSortFields.contains(field), s"Ordering field must be one of $allowedSortFields", null)
    }
  }

  def toTuple: (String, Boolean) = field -> isAscending
}

