/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.xlplatform.documentation.PublicApi;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/security")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@PublicApi
public interface PermissionService {
    @GET
    @Path(value="granted-permissions/{role}")
    public Map<String, Collection<String>> getGrantedPermissions(@PathParam(value="role") String var1);

    @GET
    @Path(value="granted-permissions/id/{roleId}")
    public Map<String, Collection<String>> getGrantedPermissionsById(@PathParam(value="roleId") String var1);

    @GET
    @Path(value="granted-permissions")
    public Map<String, Collection<String>> getMyGrantedPermissions();

    @GET
    @Path(value="permission/{permission}/{role}/{id:.+}")
    public boolean isGranted(@PathParam(value="permission") String var1, @PathParam(value="id") String var2, @PathParam(value="role") String var3);

    @GET
    @Path(value="permission/{permission}/{role}")
    default public boolean isGranted(@PathParam(value="permission") String permission, @PathParam(value="role") String role) {
        return this.isGranted(permission, "", role);
    }

    @PUT
    @Path(value="permission/{permission}/{role}/{id:.*}")
    public void grant(@PathParam(value="permission") String var1, @PathParam(value="id") String var2, @PathParam(value="role") String var3);

    @PUT
    @Path(value="permission/{permission}/{role}")
    default public void grant(@PathParam(value="permission") String permission, @PathParam(value="role") String role) {
        this.grant(permission, "", role);
    }

    @DELETE
    @Path(value="permission/{permission}/{role}/{id:.+}")
    public void revoke(@PathParam(value="permission") String var1, @PathParam(value="id") String var2, @PathParam(value="role") String var3);

    @DELETE
    @Path(value="permission/{permission}/{role}")
    default public void revoke(@PathParam(value="permission") String permission, @PathParam(value="role") String role) {
        this.revoke(permission, "", role);
    }

    @GET
    @Path(value="check/{permission}/{id:.+}")
    public boolean isGrantedToMe(@PathParam(value="permission") String var1, @PathParam(value="id") String var2);

    @GET
    @Path(value="check/{permission}")
    default public boolean isGrantedToMe(@PathParam(value="permission") String permission) {
        return this.isGrantedToMe(permission, "");
    }
}

