/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Base class for handling import URL actions.
 * Allows optional authentication
 */
@PublicApiRef
public class ImportFromUrlParams extends AbstractDto {
    private String url;
    private String credentialsId;
    private String user;
    private String password;

    public ImportFromUrlParams() {
    }

    public ImportFromUrlParams(String url) {
        this.url = url;
    }

    public ImportFromUrlParams(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }
    public ImportFromUrlParams(String url, String credentialsId) {
        this.url = url;
        this.credentialsId = credentialsId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCredentialsId() {
        return credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }
}
