/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * All possible values for the state of a step execution.
 */
@PublicApiRef
public enum StepExecutionState {
    PENDING,
    QUEUED,
    SKIP,
    EXECUTING,
    PAUSED,
    FAILED,
    DONE(true),
    SKIPPED(true);
    private boolean isFinal;

    private StepExecutionState() {
        isFinal = false;
    }

    private StepExecutionState(boolean isFinal) {
        this.isFinal = isFinal;
    }

    /**
     * @return Whether this value is final.
     */
    public boolean isFinal() {
        return isFinal;
    }

    public boolean isFinished() {
        return this == FAILED || this == DONE || this == SKIPPED || this == PAUSED;
    }
}
