/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;

/**
 * The parameter object of a control task action.
 */
@PublicApiRef
public class Control {

    private ConfigurationItem configurationItem;

    private String controlName;

    private Parameters parameters;

    public Control(ConfigurationItem configurationItem, String controlName) {
        this(configurationItem, controlName, null);
    }

    /**
     * @param configurationItem The {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem} that will execute the control task.
     * @param controlName The name of the control task.
     * @param parameters The CI that represents the {@link com.xebialabs.deployit.plugin.api.udm.Parameters} used to execute the control task.
     */
    public Control(ConfigurationItem configurationItem, String controlName, Parameters parameters) {
        this.configurationItem = configurationItem;
        this.controlName = controlName;
        this.parameters = parameters;
    }

    /**
     * @return The {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem} that will execute the control task.
     */
    public ConfigurationItem getConfigurationItem() {
        return configurationItem;
    }

    /**
     * @return The name of the control task.
     */
    public String getControlName() {
        return controlName;
    }

    /**
     * @return The {@link com.xebialabs.deployit.plugin.api.udm.Parameters} configuration item used to execute the control task.
     */
    public Parameters getParameters() {
        return parameters;
    }
}
