/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import java.util.List;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

/**
 * Inspects middleware. Provides services to discover your topology and resources and synchronize them with the state currently known in XL Deploy.
 */
@Path("/inspection")
@Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@PublicApi
public interface InspectionService {

    /**
     * Initializes the task parameter object for inspection on a CI.
     *
     * @permission discovery
     * @param ci The CI to inspect. For example, the root node of a middleware topology.
     * @return an Inspection parameter object.
     */
    @POST
    @Path("prepare")
    Inspection prepare(ConfigurationItem ci);

    /**
     * Initializes the task parameter object for inspection on a CI.
     *
     * @permission discovery
     * @param id The ID of the CI to inspect. For example, the root node of a middleware topology.
     * @return an Inspection parameter object.
     */
    @GET
    @Path("prepare/{id:.+}")
    Inspection prepare(@PathParam("id") String id);

    /**
     * Creates the inspection task
     * @restDetails for the object returned by <code>/inspection/prepare</code>
     * @apiDetails for the object returned by {@link #prepare(com.xebialabs.deployit.plugin.api.udm.ConfigurationItem)}
     *
     * @permission discovery
     * @param inspection the inspection parameter object
     * @return a reference to a Task ID that can be executed by the {@link TaskService}.
     */
    @POST
    String createTask(Inspection inspection);

    /**
     * Retrieve the inspection results
     *
     * @param taskId the Task ID of the task that ran the inspection.
     * @return the list of CIs that were inspected.
     */
    @POST
    @Path("retrieve/{taskId}")
    List<ConfigurationItem> retrieveInspectionResults(@PathParam("taskId") String taskId);
}
