/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * The parameter object of a inspection (discovery) action.
 *
 * It contains the id of the CI to inspect. For example, the root node of a middleware topology.
 */
@PublicApiRef
public class Inspection {
    private ConfigurationItem configurationItem;

    /**
     * @param configurationItem The {@link ConfigurationItem} that will be inspected.
     */
    public Inspection(ConfigurationItem configurationItem) {
        this.configurationItem = configurationItem;
    }

    /**
     * @return The {@link ConfigurationItem} that will be inspected.
     */
    public ConfigurationItem getConfigurationItem() {
        return configurationItem;
    }
}
