/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import java.util.List;

public interface CompositeBlockState extends BlockState {

    boolean isParallel();
    List<BlockState> getBlocks();

    @Override
    default Boolean hasSteps() {
        return getBlocks().stream().anyMatch(BlockState::hasSteps);
    }
}
