/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto.report;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Contains information about number of deployments per application and environment.
 */
@PublicApiRef
@XmlRootElement(name = "app-env-status-report")
public class AppEnvStatusReport extends AbstractDto {

    private String application;
    private String environment;
    private DeploymentsStatusOverview deploymentsStatusOverview;

    public AppEnvStatusReport() {
    }

    public AppEnvStatusReport(String application, String environment, DeploymentsStatusOverview deploymentsStatusOverview) {
        this.application = application;
        this.environment = environment;
        this.deploymentsStatusOverview = deploymentsStatusOverview;
    }

    /**
     * @return Application name.
     */
    @XmlElement(name = "application")
    public String getApplication() {
        return application;
    }

    /**
     * @return Environment name.
     */
    @XmlElement(name = "environment")
    public String getEnvironment() {
        return environment;
    }

    /**
     * @return DeploymentsStatusOverview which contains information about overall number of deployments per deployment state.
     */
    @XmlElement(name = "deployment-status-overview")
    public DeploymentsStatusOverview getDeploymentsStatusOverview() {
        return deploymentsStatusOverview;
    }
}
