/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.xlplatform.documentation.PublicApi;

/**
 * Provides access to control methods defined on CIs.
 */
@Path("/control")
@Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@PublicApi
public interface ControlService {

    /**
     * Returns a parameter object for the task that will execute the control task method.
     * @restDetails The returned object can be used in the call to <code>/control</code>.
     * @apiDetails The returned object is used for a call to {@link #createTask(com.xebialabs.deployit.engine.api.dto.Control)}.
     *
     * @permission controltask#execute
     * @param controlName The name of the control method to execute.
     * @param id the CI to execute the control method on
     * @return a Control parameter object.
     */
    @GET
    @Path("prepare/{controlName}/{id:.+}")
    Control prepare(@PathParam("controlName") String controlName, @PathParam("id") String id);

    /**
     * Creates the control task
     * @restDetails for the object returned by invoking <code>/control/prepare</code>.
     * @apiDetails for the object returned by {@link #prepare(String, String)}
     *
     * @permission controltask#execute
     * @param control the Control parameter object.
     * @return a reference to a Task ID that can be executed by the {@link TaskService}.
     */
    @POST
    String createTask(Control control);

}
