/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import org.joda.time.DateTime;

/**
 * Contains information about Control Task report record: task ID, start and finish date and time, state, task owner, task name,
 * target CI, task description and task blocks
 */
@PublicApiRef
public class ControlTaskReportLine {
    private String taskId;
    private DateTime started;
    private DateTime finished;
    private String state;
    private String owner;
    private String taskName;
    private String controlTaskTargetCI;
    private String description;
    private BlockState block;
    private String workerName;

    public ControlTaskReportLine() {
    }

    /**
     * @return The Taks ID.
     */
    public String getTaskId() {
        return taskId;
    }

    /**
     * @param taskId The Taks ID.
     * @return The this object.
     */
    public ControlTaskReportLine setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    /**
     * @return The Start Date of Task.
     */
    public DateTime getStarted() {
        return started;
    }

    /**
     * @param started The Start Date of Task.
     * @return The this object.
     */
    public ControlTaskReportLine setStarted(DateTime started) {
        this.started = started;
        return this;
    }

    /**
     * @return The Completion Date of Task.
     */
    public DateTime getFinished() {
        return finished;
    }

    /**
     * @param finished The Completion Date of Task.
     * @return The this object.
     */
    public ControlTaskReportLine setFinished(DateTime finished) {
        this.finished = finished;
        return this;
    }

    /**
     * @return The State of Task.
     */
    public String getState() {
        return state;
    }

    /**
     * @param state The State of Task.
     * @return The this object.
     */
    public ControlTaskReportLine setState(String state) {
        this.state = state;
        return this;
    }

    /**
     * @return The owner user associated with the Task.
     */
    public String getOwner() {
        return owner;
    }

    /**
     * @param owner The owner user associated with the Task.
     * @return The this object.
     */
    public ControlTaskReportLine setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    /**
     * @return The name of run Control Task.
     */
    public String getTaskName() {
        return taskName;
    }

    /**
     * @param taskName TThe name of run Control Task.
     * @return The this object.
     */
    public ControlTaskReportLine setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * @return The Target CI path associated with the Task.
     */
    public String getControlTaskTargetCI() {
        return controlTaskTargetCI;
    }

    /**
     * @param controlTaskTargetCI The Target CI path associated with the Task.
     * @return The this object.
     */
    public ControlTaskReportLine setControlTaskTargetCI(String controlTaskTargetCI) {
        this.controlTaskTargetCI = controlTaskTargetCI;
        return this;
    }

    /**
     * @return The Task description.
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description The Task description.
     * @return The this object.
     */
    public ControlTaskReportLine setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * @return If FULL FetchMode was toggled block field will contain details of task execution blocks.
     */
    public BlockState getBlock() {
        return block;
    }

    /**
     * @param block The Task execution blocks.
     * @return The this object.
     */
    public ControlTaskReportLine setBlock(BlockState block) {
        this.block = block;
        return this;
    }

    /**
     * @return The name of worker that executes this task.
     */
    public String getWorkerName() {
        return workerName;
    }

    /**
     * @param workerName The name of worker that executes this task.
     * @return The this object.
     */
    public ControlTaskReportLine setWorkerName(String workerName) {
        this.workerName = workerName;
        return this;
    }
}
