/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.security;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

import java.util.Date;

/**
 * Representation of XL Deploy user Profile
 */
@XmlRootElement(name = "profile")
public class UserProfile extends AbstractDto {

    private String fullName;

    private String email;

    private Date lastActive;

    private Boolean loginAllowed;

    private Boolean isInternal = true;

    private String displayUsername;

    @XmlElement(name = "fullName")
    public String getFullName() {
        return fullName;
    }
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @XmlElement(name = "email")
    public String getEmail() {
        return email;
    }
    public void setEmail(String email) {
        this.email = email;
    }

    @XmlElement(name = "loginAllowed")
    public Boolean getLoginAllowed() {
        return loginAllowed;
    }
    public void setLoginAllowed(Boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
    }

    @XmlElement(name = "lastActive")
    public Date getLastActive() {
        return lastActive;
    }
    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }

    @XmlElement(name = "isInternal")
    public Boolean getIsInternal() {
        return isInternal;
    }
    public void setIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
    }

    @XmlElement(name = "displayUsername")
    public String getDisplayUsername() { return displayUsername; }
    public void setDisplayUsername(String displayUsername) { this.displayUsername = displayUsername; }
}
