/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EditRolePermissionsDto extends AbstractDto implements Serializable {

    private String roleName;
    private List<String> addedPermissions = new ArrayList<>();
    private List<String> removedPermissions = new ArrayList<>();

    public EditRolePermissionsDto() {
    }

    public EditRolePermissionsDto(String roleName, List<String> addedPermissions, List<String> removedPermissions) {
        this.roleName = roleName;
        this.addedPermissions = addedPermissions;
        this.removedPermissions = removedPermissions;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public List<String> getAddedPermissions() {
        return addedPermissions;
    }

    public void setAddedPermissions(List<String> addedPermissions) {
        this.addedPermissions = addedPermissions;
    }

    public List<String> getRemovedPermissions() {
        return removedPermissions;
    }

    public void setRemovedPermissions(List<String> removedPermissions) {
        this.removedPermissions = removedPermissions;
    }
}
