/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto


import jakarta.ws.rs.{DefaultValue, QueryParam}

import com.xebialabs.deployit.checks.Checks.checkArgument
import com.xebialabs.xlplatform.documentation.PublicApiRef

import scala.beans.BeanProperty

object Paging {
  val X_TOTAL_COUNT_HEADER = "X-Total-Count"
  val X_HAS_NEXT_PAGE_HEADER = "X-Has-Next-Page"
}

/**
  * The parameter object for pagination.
  */
@PublicApiRef
class Paging(private val _page: Int, private val _resultsPerPage: Int) {
  @QueryParam("page")
  @DefaultValue("1")
  @BeanProperty
  var page: Int = _page

  @QueryParam("resultsPerPage")
  @DefaultValue("-1")
  @BeanProperty
  var resultsPerPage: Int = _resultsPerPage

  def this() = this(1, -1)

  def validate(): Unit = {
    checkArgument(resultsPerPage <= 0 || page >= 0, "Page should be a positive number if result size is limited.", None)
  }

  def toTuple: (Int, Int) = page -> resultsPerPage
}
