/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import org.jboss.resteasy.annotations.providers.multipart.PartType;

import java.io.File;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.MediaType;

/**
 * Base class for handling RESTEasy file uploads.
 */
@PublicApiRef
public class FileUpload extends AbstractDto {

    @FormParam("fileData")
    @PartType(MediaType.APPLICATION_OCTET_STREAM)
    private File fileData;

    /**
     * @return The InputStream to read the uploaded file from.
     */
    public File getFileData() {
        return fileData;
    }

    /**
     * @param fileData The InputStream to read the uploaded file from.
     */
    public void setFileData(final File fileData) {
        this.fileData = fileData;
    }

}
