/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.xml;

import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.spi.DecoratorProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.ws.rs.core.MediaType;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import java.lang.annotation.*;

/**
 * Ensures that the XML Preamble is removed from the response, this facilitates certain broken Rest clients
 * which need a wrapped XML response.
 */
@Retention(RetentionPolicy.RUNTIME)
@Decorator(processor = OmitXmlPreamble.Processor.class, target = Marshaller.class)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
@Inherited
public @interface OmitXmlPreamble {

    class Processor implements DecoratorProcessor<Marshaller, OmitXmlPreamble> {
        @Override
        public Marshaller decorate(Marshaller target, OmitXmlPreamble annotation, Class type, Annotation[] annotations, MediaType mediaType) {
            try {
                target.setProperty(Marshaller.JAXB_FRAGMENT, true);
                logger.trace("Omitting XML Preamble");
                return target;
            } catch (PropertyException ignored) {
                return target;
            }
        }
        private static final Logger logger = LoggerFactory.getLogger(OmitXmlPreamble.Processor.class);
    }
}
