/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.api.execution;

import java.util.List;
import java.util.Map;

import org.joda.time.DateTime;

/**
 * Represents a task.
 *
 * A task is an activity in XL Deploy. The task contains a list of steps that must be executed to successfully complete
 * the task.
 */
public interface SerializableTask {

    /**
     * @return The execution state of a task.
     */
    TaskExecutionState getState();

    /**
     * @return The task id.
     */
    String getId();

    /**
     * @return Textual description of the task.
     */
    String getDescription();

    /**
     * @return The scheduled date and time for the execution of the task.
     */
    DateTime getScheduledDate();

    /**
     * @return The date and time the execution of the steps was started.
     */
    DateTime getStartDate();

    /**
     * @return The date and time the execution of the steps was completed.
     */
    DateTime getCompletionDate();

    /**
     * @return Map with metadata (custom properties) for this task.
     */
    Map<String, String> getMetadata();

    /**
     * @return The number of times this task has failed.
     */
    int getFailureCount();

    /**
     * @return The id of the user that is the owner of this task.
     */
    String getOwner();

    /**
     * @return The list of dependent packages of this task
     */
    List<TaskPackageDependency> getPackageDependencies();

    /**
     * @return The (technical) id of the worker that is handling this task.
     */
    Integer getWorkerId();

}
