package com.xebialabs.deployit.engine.api;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

/**
 * Inspects middleware. Provides services to discover your topology and resources and synchronize them with the state currently known in Deployit.
 */
@Path("/inspection")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface InspectionService {

    /**
     * Initializes the task parameter object for inspection on a CI.
     *
     * @permission discovery
     * @param ci The CI to inspect. For example, the root node of a middleware topology.
     * @return an Inspection parameter object.
     */
    @POST
    @Path("prepare")
    Inspection prepare(ConfigurationItem ci);

    /**
     * Initializes the task parameter object for inspection on a CI.
     *
     * @permission discovery
     * @param id The id of the CI to inspect. For example, the root node of a middleware topology.
     * @return an Inspection parameter object.
     */
    @GET
    @Path("prepare/{id:.*?}")
    Inspection prepare(@PathParam("id") String id);

    /**
     * Creates the inspection task.
     *
     * @permission discovery
     * @param inspection the inspection parameter object, created by invoking <code>/inspection/prepare</code>.
     * @return a reference to a Task ID that can be executed by the {@link TaskService}.
     */
    @POST
    String createTask(Inspection inspection);

    /**
     * Retrieved the inspection results
     *
     * @param taskId the Task ID of the task that ran the inspection.
     * @return the list of CIs that were inspected.
     */
    @POST
    @Path("retrieve/{taskId}")
    List<ConfigurationItem> retrieveInspectionResults(@PathParam("taskId") String taskId);
}
